/*
 * Decompiled with CFR 0.152.
 */
package jama.util;

import jama.FloatMatrix;
import jama.Matrix;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class MatrixWriter
extends PrintWriter {
    private NumberFormat format;
    private int width;

    public MatrixWriter(OutputStream out) {
        super(out);
        this.init();
    }

    public MatrixWriter(Writer out) {
        super(out);
        this.init();
    }

    private void init() {
        this.setWidth(10);
        this.setDigits(10);
    }

    public MatrixWriter setFormatter(NumberFormat format) {
        this.format = format;
        return this;
    }

    public MatrixWriter setWidth(int width) {
        this.width = width;
        return this;
    }

    public MatrixWriter setDigits(int digits) {
        this.format = new DecimalFormat();
        ((DecimalFormat)this.format).setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        this.format.setMinimumIntegerDigits(1);
        this.format.setMaximumFractionDigits(digits);
        this.format.setMinimumFractionDigits(digits);
        this.format.setGroupingUsed(false);
        return this;
    }

    public void writeMatrix(Matrix matrix) {
        this.println();
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            for (int col = 0; col < matrix.getColumnDimension(); ++col) {
                String s = this.format.format(matrix.get(row, col));
                int padding = Math.max(1, this.width - s.length());
                for (int k = 0; k < padding; ++k) {
                    this.print(' ');
                }
                this.print(s);
            }
            this.println();
        }
        this.println();
        this.flush();
    }

    public void writeMatrix(FloatMatrix matrix) {
        this.println();
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            for (int col = 0; col < matrix.getColumnDimension(); ++col) {
                String s = this.format.format(matrix.get(row, col));
                int padding = Math.max(1, this.width - s.length());
                for (int k = 0; k < padding; ++k) {
                    this.print(' ');
                }
                this.print(s);
            }
            this.println();
        }
        this.println();
        this.flush();
    }

    public static String toString(Matrix matrix, int width, int digits) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(digits);
        format.setMinimumFractionDigits(digits);
        format.setGroupingUsed(false);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (int row = 0; row < matrix.getRowDimension(); ++row) {
            for (int col = 0; col < matrix.getColumnDimension(); ++col) {
                String s = format.format(matrix.get(row, col));
                int padding = Math.max(1, width - s.length());
                for (int k = 0; k < padding; ++k) {
                    sb.append(' ');
                }
                sb.append(s);
            }
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }
}

