/*
 * Decompiled with CFR 0.152.
 */
package de.neuefische.java.fallbackpage;

import java.io.IOException;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
public class FallbackPage
implements WebMvcConfigurer {
    public static final String DEFAULT_STARTING_PAGE = "static/index.html";

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"}).resourceChain(true).addResolver((ResourceResolver)new ReactRoutingPathResourceResolver());
    }

    static class ReactRoutingPathResourceResolver
    extends PathResourceResolver {
        ReactRoutingPathResourceResolver() {
        }

        protected Resource getResource(String resourcePath, Resource location) throws IOException {
            Resource requestedResource = location.createRelative(resourcePath);
            if (requestedResource.exists() && requestedResource.isReadable()) {
                return requestedResource;
            }
            return new ClassPathResource(FallbackPage.DEFAULT_STARTING_PAGE);
        }
    }
}

