/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.assertj.logging;

import de.neuland.assertj.logging.GenericExpectedLogging;
import de.neuland.assertj.logging.LogEvent;
import de.neuland.assertj.logging.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;

public class ExpectedLoggingAssert
extends ListAssert<LogEvent> {
    public ExpectedLoggingAssert(GenericExpectedLogging<?> actual) {
        super(actual.getLogEvents());
    }

    public ExpectedLoggingAssert hasErrorMessage(String actualMessage) {
        return this.hasMessageWithLevel(LogLevel.ERROR, actualMessage);
    }

    public ExpectedLoggingAssert hasErrorMessage(String message, Throwable throwable) {
        return this.hasMessageWithLevelAndThrowable(LogLevel.ERROR, message, throwable);
    }

    public ExpectedLoggingAssert hasErrorMessageMatching(String regex) {
        return this.hasMessageMatching(LogLevel.ERROR, regex);
    }

    public ExpectedLoggingAssert hasErrorMessageMatching(String regex, Throwable throwable) {
        return this.hasMessageMatching(LogLevel.ERROR, regex, throwable);
    }

    public ExpectedLoggingAssert hasNoErrorMessage() {
        return this.hasNoMessageWithLevel(this.errorMessages(), LogLevel.ERROR);
    }

    public ListAssert<LogEvent> errorMessages() {
        return this.messagesWithLevel(LogLevel.ERROR);
    }

    public ExpectedLoggingAssert hasWarningMessage(String actualMessage) {
        return this.hasMessageWithLevel(LogLevel.WARNING, actualMessage);
    }

    public ExpectedLoggingAssert hasWarningMessage(String actualMessage, Throwable actualDetail) {
        return this.hasMessageWithLevelAndThrowable(LogLevel.WARNING, actualMessage, actualDetail);
    }

    public ExpectedLoggingAssert hasWarningMessageMatching(String regex) {
        return this.hasMessageMatching(LogLevel.WARNING, regex);
    }

    public ExpectedLoggingAssert hasWarningMessageMatching(String regex, Throwable throwable) {
        return this.hasMessageMatching(LogLevel.WARNING, regex, throwable);
    }

    public ExpectedLoggingAssert hasNoWarningMessage() {
        return this.hasNoMessageWithLevel(this.warningMessages(), LogLevel.WARNING);
    }

    public ListAssert<LogEvent> warningMessages() {
        return this.messagesWithLevel(LogLevel.WARNING);
    }

    public ExpectedLoggingAssert hasInfoMessage(String actualMessage) {
        return this.hasMessageWithLevel(LogLevel.INFO, actualMessage);
    }

    public ExpectedLoggingAssert hasInfoMessageMatching(String regex) {
        return this.hasMessageMatching(LogLevel.INFO, regex);
    }

    public ListAssert<LogEvent> hasNoInfoMessage() {
        return this.hasNoMessageWithLevel(this.infoMessages(), LogLevel.INFO);
    }

    public ListAssert<LogEvent> infoMessages() {
        return this.messagesWithLevel(LogLevel.INFO);
    }

    private ExpectedLoggingAssert hasMessageMatching(final LogLevel logLevel, final String regex) {
        ((ListAssert)this.withFailMessage("Expected %s message matching '%s'.\nBut only found:\n%s", new Object[]{logLevel, regex, this.joinLogEvents()})).haveAtLeastOne((Condition)new Condition<LogEvent>(){

            public boolean matches(LogEvent logEvent) {
                return logEvent.getLevel() == logLevel && logEvent.matchesMessage(regex);
            }
        });
        return this;
    }

    private ExpectedLoggingAssert hasMessageMatching(final LogLevel logLevel, final String regex, final Throwable throwable) {
        ((ListAssert)this.withFailMessage("Expected %s message matching '%s'.\nBut only found:\n%s", new Object[]{logLevel, regex, this.joinLogEvents()})).haveAtLeastOne((Condition)new Condition<LogEvent>(){

            public boolean matches(LogEvent logEvent) {
                return logEvent.getLevel() == logLevel && logEvent.matchesMessage(regex) && logEvent.getThrowable() == throwable;
            }
        });
        return this;
    }

    private ListAssert<LogEvent> messagesWithLevel(LogLevel logLevel) {
        return (ListAssert)this.filteredOn(new LogLevelFilter(logLevel));
    }

    private ExpectedLoggingAssert hasMessageWithLevelAndThrowable(LogLevel logLevel, String actualMessage, Throwable actualThrowable) {
        this.extracting(new String[]{"message", "level", "throwable"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{actualMessage, logLevel, actualThrowable})});
        return this;
    }

    private ExpectedLoggingAssert hasMessageWithLevel(LogLevel logLevel, String actualMessage) {
        this.extracting(new String[]{"level", "message"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{logLevel, actualMessage})});
        return this;
    }

    private ExpectedLoggingAssert hasNoMessageWithLevel(ListAssert<LogEvent> logEvents, LogLevel logLevel) {
        ((ListAssert)logEvents.withFailMessage("Expected no %s message.\nBut found:\n%s", new Object[]{logLevel, this.joinLogEvents(logLevel)})).isEmpty();
        return this;
    }

    private String joinLogEvents() {
        return this.joinLogEvents((List)this.actual);
    }

    private String joinLogEvents(LogLevel logLevel) {
        return this.joinLogEvents(this.filterActual(new LogLevelFilter(logLevel)));
    }

    private List<? extends LogEvent> filterActual(LogLevelFilter logLevelFilter) {
        ArrayList result = new ArrayList((Collection)this.actual);
        for (LogEvent logEvent : (List)this.actual) {
            if (logLevelFilter.matches(logEvent)) continue;
            result.remove(logEvent);
        }
        return result;
    }

    private String joinLogEvents(List<? extends LogEvent> actual) {
        if (actual == null || actual.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < actual.size(); ++i) {
            sb.append(actual.get(i).toString());
            if (i == actual.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class LogLevelFilter
    extends Condition<LogEvent> {
        private final LogLevel logLevel;

        LogLevelFilter(LogLevel logLevel) {
            this.logLevel = logLevel;
        }

        public boolean matches(LogEvent logEvent) {
            return this.logLevel.equals((Object)logEvent.getLevel());
        }
    }
}

