/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.assertj.logging;

import de.neuland.assertj.logging.LogEvent;
import de.neuland.assertj.logging.LogEventCaptureAppender;
import java.util.List;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class GenericExpectedLogging<APPENDER extends LogEventCaptureAppender>
implements BeforeEachCallback,
AfterEachCallback {
    final String loggingSource;
    private final ThreadLocal<APPENDER> threadLocalAppender = new ThreadLocal();

    GenericExpectedLogging(String loggingSource) {
        this.loggingSource = loggingSource;
    }

    public void beforeEach(ExtensionContext context) {
        APPENDER captureAppender = this.addCaptureAppender();
        this.assertLoggerLevelIsAtLeastInfo();
        this.threadLocalAppender.set(captureAppender);
    }

    public void afterEach(ExtensionContext context) {
        this.removeCaptureAppender((LogEventCaptureAppender)this.threadLocalAppender.get());
    }

    abstract APPENDER addCaptureAppender();

    abstract void assertLoggerLevelIsAtLeastInfo();

    abstract void removeCaptureAppender(APPENDER var1);

    public List<LogEvent> getLogEvents() {
        return ((LogEventCaptureAppender)this.threadLocalAppender.get()).getLogEvents();
    }
}

