/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.lexer;

import de.neuland.jade4j.exceptions.JadeLexerException;
import de.neuland.jade4j.lexer.Assignment;
import de.neuland.jade4j.lexer.AttributeLexer;
import de.neuland.jade4j.lexer.Each;
import de.neuland.jade4j.lexer.Scanner;
import de.neuland.jade4j.lexer.token.Attribute;
import de.neuland.jade4j.lexer.token.Block;
import de.neuland.jade4j.lexer.token.CaseToken;
import de.neuland.jade4j.lexer.token.Colon;
import de.neuland.jade4j.lexer.token.Comment;
import de.neuland.jade4j.lexer.token.CssClass;
import de.neuland.jade4j.lexer.token.CssId;
import de.neuland.jade4j.lexer.token.Default;
import de.neuland.jade4j.lexer.token.Doctype;
import de.neuland.jade4j.lexer.token.Dot;
import de.neuland.jade4j.lexer.token.Else;
import de.neuland.jade4j.lexer.token.ElseIf;
import de.neuland.jade4j.lexer.token.Eos;
import de.neuland.jade4j.lexer.token.Expression;
import de.neuland.jade4j.lexer.token.ExtendsToken;
import de.neuland.jade4j.lexer.token.Filter;
import de.neuland.jade4j.lexer.token.If;
import de.neuland.jade4j.lexer.token.Include;
import de.neuland.jade4j.lexer.token.Indent;
import de.neuland.jade4j.lexer.token.Mixin;
import de.neuland.jade4j.lexer.token.MixinInject;
import de.neuland.jade4j.lexer.token.Newline;
import de.neuland.jade4j.lexer.token.Outdent;
import de.neuland.jade4j.lexer.token.Tag;
import de.neuland.jade4j.lexer.token.Text;
import de.neuland.jade4j.lexer.token.Token;
import de.neuland.jade4j.lexer.token.When;
import de.neuland.jade4j.lexer.token.While;
import de.neuland.jade4j.lexer.token.Yield;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    private LinkedList<String> options;
    Scanner scanner;
    private LinkedList<Token> deferredTokens;
    private int lastIndents = -1;
    private int lineno;
    private LinkedList<Token> stash;
    private LinkedList<Integer> indentStack;
    private String indentRe = null;
    private boolean pipeless = false;
    private boolean attributeMode;
    private Reader reader;
    private final String filename;
    private final TemplateLoader templateLoader;
    private String indentType;

    public Lexer(String filename, TemplateLoader templateLoader) throws IOException {
        this.filename = filename;
        this.templateLoader = templateLoader;
        this.reader = templateLoader.getReader(filename);
        this.options = new LinkedList();
        this.scanner = new Scanner(this.reader);
        this.deferredTokens = new LinkedList();
        this.stash = new LinkedList();
        this.indentStack = new LinkedList();
        this.lastIndents = 0;
        this.lineno = 1;
    }

    public Token next() {
        this.handleBlankLines();
        Token token = null;
        if (token == null) {
            token = this.deferred();
        }
        if (token == null) {
            token = this.eos();
        }
        if (token == null) {
            token = this.pipelessText();
        }
        if (token == null) {
            token = this.yield();
        }
        if (token == null) {
            token = this.doctype();
        }
        if (token == null) {
            token = this.caseToken();
        }
        if (token == null) {
            token = this.when();
        }
        if (token == null) {
            token = this.defaultToken();
        }
        if (token == null) {
            token = this.extendsToken();
        }
        if (token == null) {
            token = this.append();
        }
        if (token == null) {
            token = this.prepend();
        }
        if (token == null) {
            token = this.block();
        }
        if (token == null) {
            token = this.include();
        }
        if (token == null) {
            token = this.mixin();
        }
        if (token == null) {
            token = this.mixinInject();
        }
        if (token == null) {
            token = this.conditional();
        }
        if (token == null) {
            token = this.each();
        }
        if (token == null) {
            token = this.whileToken();
        }
        if (token == null) {
            token = this.assignment();
        }
        if (token == null) {
            token = this.tag();
        }
        if (token == null) {
            token = this.filter();
        }
        if (token == null) {
            token = this.code();
        }
        if (token == null) {
            token = this.id();
        }
        if (token == null) {
            token = this.className();
        }
        if (token == null) {
            token = this.attributes();
        }
        if (token == null) {
            token = this.indent();
        }
        if (token == null) {
            token = this.comment();
        }
        if (token == null) {
            token = this.colon();
        }
        if (token == null) {
            token = this.dot();
        }
        if (token == null) {
            token = this.text();
        }
        if (token == null) {
            throw new JadeLexerException("token not recognized " + this.scanner.getInput().substring(0, 5), this.filename, this.getLineno(), this.templateLoader);
        }
        return token;
    }

    public void handleBlankLines() {
        while (this.scanner.isAdditionalBlankline()) {
            this.consume(1);
            ++this.lineno;
        }
    }

    public void consume(int len) {
        this.scanner.consume(len);
    }

    public void defer(Token tok) {
        this.deferredTokens.add(tok);
    }

    public Token lookahead(int n) {
        for (int fetch = n - this.stash.size(); fetch > 0; --fetch) {
            this.stash.add(this.next());
        }
        return this.stash.get(--n);
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setPipeless(boolean pipeless) {
        this.pipeless = pipeless;
    }

    public Token advance() {
        Token t = this.stashed();
        return t != null ? t : this.next();
    }

    private String scan(String regexp) {
        String result = null;
        Matcher matcher = this.scanner.getMatcherForPattern(regexp);
        if (matcher.find(0) && matcher.groupCount() > 0) {
            int end = matcher.end();
            this.consume(end);
            return matcher.group(1);
        }
        return result;
    }

    private Token stashed() {
        if (this.stash.size() > 0) {
            return this.stash.poll();
        }
        return null;
    }

    private Token deferred() {
        if (this.deferredTokens.size() > 0) {
            return this.deferredTokens.poll();
        }
        return null;
    }

    private Token eos() {
        if (this.scanner.getInput().length() > 0) {
            return null;
        }
        if (this.indentStack.size() > 0) {
            this.indentStack.poll();
            return new Outdent("outdent", this.lineno);
        }
        return new Eos("eos", this.lineno);
    }

    private Token comment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^ *\\/\\/(-)?([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            boolean buffer = !"-".equals(matcher.group(1));
            Comment comment = new Comment(matcher.group(2).trim(), this.lineno, buffer);
            this.consume(matcher.end());
            return comment;
        }
        return null;
    }

    private Token code() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(!?=|-)([^\\n]+)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Expression code = new Expression(matcher.group(2), this.lineno);
            String type = matcher.group(1);
            code.setEscape(type.equals("="));
            code.setBuffer(type.equals("=") || type.equals("!="));
            this.consume(matcher.end());
            return code;
        }
        return null;
    }

    private Token tag() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(\\w[-:\\w]*)(\\/?)");
        if (matcher.find(0) && matcher.groupCount() > 0) {
            Tag tok;
            this.consume(matcher.end());
            String name = matcher.group(1);
            if (':' == name.charAt(name.length() - 1)) {
                name = name.substring(0, name.length() - 1);
                tok = new Tag(name, this.lineno);
                this.defer(new Colon(":", this.lineno));
                while (' ' == this.scanner.getInput().charAt(0)) {
                    this.scanner.consume(1);
                }
            } else {
                tok = new Tag(name, this.lineno);
            }
            if (!matcher.group(2).isEmpty()) {
                tok.setSelfClosing(true);
            }
            return tok;
        }
        return null;
    }

    private Token yield() {
        Matcher matcher = this.scanner.getMatcherForPattern("^yield *");
        if (matcher.find(0)) {
            matcher.group(0);
            int end = matcher.end();
            this.consume(end);
            return new Yield("yield", this.lineno);
        }
        return null;
    }

    private Token filter() {
        String val = this.scan("^:(\\w+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new Filter(val, this.lineno);
        }
        return null;
    }

    private Token each() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(?:- *)?(?:each|for) +(\\w+)(?: *, *(\\w+))? * in *([^\\n]+)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            this.consume(matcher.end());
            String value = matcher.group(1);
            String key = matcher.group(2);
            String code = matcher.group(3);
            Each each = new Each(value, this.lineno);
            each.setCode(code);
            each.setKey(key);
            return each;
        }
        return null;
    }

    private Token whileToken() {
        String val = this.scan("^while +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new While(val, this.lineno);
        }
        return null;
    }

    private Token conditional() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(if|unless|else if|else)\\b([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String type = matcher.group(1);
            String condition = matcher.group(2);
            this.consume(matcher.end());
            if ("else".equals(type)) {
                return new Else(null, this.lineno);
            }
            if ("else if".equals(type)) {
                return new ElseIf(condition, this.lineno);
            }
            If ifToken = new If(condition, this.lineno);
            ifToken.setInverseCondition("unless".equals(type));
            return ifToken;
        }
        return null;
    }

    private Token doctype() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(?:!!!|doctype) *([^\\n]+)?");
        if (matcher.find(0) && matcher.groupCount() > 0) {
            this.consume(matcher.end());
            return new Doctype(matcher.group(1), this.lineno);
        }
        return null;
    }

    private Token id() {
        String val = this.scan("^#([\\w-]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new CssId(val, this.lineno);
        }
        return null;
    }

    private Token className() {
        String val = this.scan("^\\.([\\w-]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new CssClass(val, this.lineno);
        }
        return null;
    }

    private Token text() {
        String val = this.scan("^(?:\\| ?| ?)?([^\\n]+)");
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            return new Text(val, this.lineno);
        }
        return null;
    }

    private Token extendsToken() {
        String val = this.scan("^extends? +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new ExtendsToken(val, this.lineno);
        }
        return null;
    }

    private Token prepend() {
        String name = this.scan("^prepend +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            Block tok = new Block(name, this.lineno);
            tok.setMode("prepend");
            return tok;
        }
        return null;
    }

    private Token append() {
        String name = this.scan("^append +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            Block tok = new Block(name, this.lineno);
            tok.setMode("append");
            return tok;
        }
        return null;
    }

    private Token block() {
        Matcher matcher = this.scanner.getMatcherForPattern("^block\\b *(?:(prepend|append) +)?([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String val = matcher.group(1);
            String mode = StringUtils.isNotBlank((CharSequence)val) ? val : "replace";
            String name = matcher.group(2);
            Block tok = new Block(name, this.lineno);
            tok.setMode(mode);
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token include() {
        String val = this.scan("^include +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new Include(val, this.lineno);
        }
        return null;
    }

    private Token caseToken() {
        String val = this.scan("^case +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new CaseToken(val, this.lineno);
        }
        return null;
    }

    private Token when() {
        String val = this.scan("^when +([^:\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new When(val, this.lineno);
        }
        return null;
    }

    private Token defaultToken() {
        String val = this.scan("^(default *)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new Default(val, this.lineno);
        }
        return null;
    }

    private Token assignment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(\\w+) += *([^;\\n]+)( *;? *)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String name = matcher.group(1);
            String val = matcher.group(2);
            this.consume(matcher.end());
            Assignment assign = new Assignment(val, this.lineno);
            assign.setName(name);
            return assign;
        }
        return null;
    }

    private Token dot() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\.");
        if (matcher.find(0)) {
            Dot tok = new Dot(".", this.lineno);
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token mixin() {
        Matcher matcher = this.scanner.getMatcherForPattern("^mixin +([-\\w]+)(?: *\\((.*)\\))?");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            Mixin tok = new Mixin(matcher.group(1), this.lineno);
            tok.setArguments(matcher.group(2));
            this.consume(matcher.end());
            return tok;
        }
        return null;
    }

    private Token mixinInject() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\+([-\\w]+)");
        if (matcher.find(0) && matcher.groupCount() > 0) {
            Matcher attributeMatcher;
            MixinInject tok = new MixinInject(matcher.group(1), this.lineno);
            this.consume(matcher.end());
            matcher = this.scanner.getMatcherForPattern("^ *\\((.*?)\\)");
            if (matcher.find(0) && matcher.groupCount() > 0 && !(attributeMatcher = Pattern.compile("^ *[-\\w]+ *=").matcher(matcher.group(1))).find(0)) {
                tok.setArguments(matcher.group(1));
                this.consume(matcher.end());
            }
            return tok;
        }
        return null;
    }

    private Token attributes() {
        if ('(' != this.scanner.charAt(0)) {
            return null;
        }
        int index = this.indexOfDelimiters('(', ')');
        if (index == 0) {
            throw new JadeLexerException("invalid attribute definition; missing )", this.filename, this.getLineno(), this.templateLoader);
        }
        String string = this.scanner.getInput().substring(1, index);
        this.consume(index + 1);
        Attribute attribute = new AttributeLexer().getToken(string, this.lineno);
        if (this.scanner.getInput().charAt(0) == '/') {
            this.consume(1);
            attribute.setSelfClosing(true);
        }
        return attribute;
    }

    private int indexOfDelimiters(char start, char end) {
        String str = this.scanner.getInput();
        int nstart = 0;
        int nend = 0;
        int pos = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (start == str.charAt(i)) {
                ++nstart;
                continue;
            }
            if (end != str.charAt(i) || ++nend != nstart) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private Token indent() {
        Matcher matcher;
        if (this.indentRe != null) {
            matcher = this.scanner.getMatcherForPattern(this.indentRe);
        } else {
            String re = "^\\n(\\t*) *";
            String indentType = "tabs";
            matcher = this.scanner.getMatcherForPattern(re);
            if (matcher.find(0) && matcher.groupCount() < 2) {
                re = "^\\n( *)";
                indentType = "spaces";
                matcher = this.scanner.getMatcherForPattern(re);
            }
            if (matcher.find(0) && matcher.groupCount() > 0) {
                this.indentRe = re;
            }
            this.indentType = indentType;
        }
        if (matcher.find(0) && matcher.groupCount() > 0) {
            Token tok;
            int indents = matcher.group(1).length();
            if (this.lastIndents <= 0 && indents > 0) {
                this.lastIndents = indents;
            }
            ++this.lineno;
            this.consume(indents + 1);
            if (indents > 0 && this.lastIndents > 0 && indents % this.lastIndents != 0 || this.scanner.isIntendantionViolated()) {
                throw new JadeLexerException("invalid indentation; expecting " + indents + " " + this.indentType, this.filename, this.getLineno(), this.templateLoader);
            }
            if (this.scanner.isBlankLine()) {
                return new Newline("newline", this.lineno);
            }
            if (this.indentStack.size() > 0 && indents < this.indentStack.get(0)) {
                while (this.indentStack.size() > 0 && this.indentStack.get(0) > indents) {
                    this.stash.add(new Outdent("outdent", this.lineno));
                    this.indentStack.poll();
                }
                tok = this.stash.pollLast();
            } else if (indents > 0 && (this.indentStack.size() < 1 || indents != this.indentStack.get(0))) {
                this.indentStack.push(indents);
                tok = new Indent("indent", this.lineno);
                tok.setIndents(indents);
            } else {
                tok = new Newline("newline", this.lineno);
            }
            return tok;
        }
        return null;
    }

    private Token pipelessText() {
        if (this.pipeless) {
            if ('\n' == this.scanner.getInput().charAt(0)) {
                return null;
            }
            int i = this.scanner.getInput().indexOf(10);
            if (-1 == i) {
                i = this.scanner.getInput().length();
            }
            String str = this.scanner.getInput().substring(0, i);
            this.consume(str.length());
            return new Text(str, this.lineno);
        }
        return null;
    }

    private Token colon() {
        String val = this.scan("^(: *)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return new Colon(val, this.lineno);
        }
        return null;
    }

    public boolean getPipeless() {
        return this.pipeless;
    }
}

