/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.compiler.Utils;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.LinkedList;
import java.util.List;

public class TextNode
extends Node {
    private String value = "";
    private List<Object> preparedValue = new LinkedList<Object>();

    public void appendText(String txt) {
        this.value = this.value + txt;
        this.prepare();
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.prepare();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private void prepare() {
        this.preparedValue = Utils.prepareInterpolate(this.value, false);
    }

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        try {
            String string = Utils.interpolate(this.preparedValue, model);
            writer.append(string);
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    @Override
    public LinkedList<Node> getNodes() {
        return this.nodes;
    }
}

