/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.model;

import de.neuland.jade4j.filter.Filter;
import de.neuland.jade4j.parser.node.MixinNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class JadeModel
implements Map<String, Object> {
    private static final String LOCALS = "locals";
    private Deque<Map<String, Object>> scopes = new LinkedList<Map<String, Object>>();
    private Map<String, MixinNode> mixins = new HashMap<String, MixinNode>();
    private Map<String, Filter> filter = new HashMap<String, Filter>();

    public JadeModel(Map<String, Object> defaults) {
        HashMap rootScope = new HashMap();
        this.scopes.add(rootScope);
        if (defaults != null) {
            this.putAll((Map<? extends String, ? extends Object>)defaults);
        }
        this.put(LOCALS, (Object)this);
    }

    public void pushScope() {
        HashMap scope = new HashMap();
        this.scopes.add(scope);
    }

    public void popScope() {
        this.scopes.removeLast();
    }

    public void setMixin(String name, MixinNode node) {
        this.mixins.put(name, node);
    }

    public MixinNode getMixin(String name) {
        return this.mixins.get(name);
    }

    @Override
    public void clear() {
        this.scopes.clear();
        this.scopes.add(new HashMap());
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            map.put(key, this.get(key));
        }
        return map.entrySet();
    }

    @Override
    public Object get(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            return scope.get(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            keys.addAll(i.next().keySet());
        }
        return keys;
    }

    @Override
    public Object put(String key, Object value) {
        Object currentValue = this.get(key);
        this.scopes.getLast().put(key, value);
        return currentValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.scopes.getLast().putAll(m);
    }

    @Override
    public Object remove(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            Object object = scope.get(key);
            scope.remove(key);
            return object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    public Filter getFilter(String name) {
        return this.filter.get(name);
    }

    public void addFilter(String name, Filter filter) {
        this.filter.put(name, filter);
    }
}

