/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.Parser;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.parser.node.TagNode;
import de.neuland.jade4j.parser.node.TextNode;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.ArrayList;
import java.util.Collection;

public class BlockNode
extends Node {
    private boolean yield = false;
    private BlockNode yieldBlock;
    private String mode;
    private Collection<? extends Node> prepended = new ArrayList<Node>();
    private Collection<? extends Node> appended = new ArrayList<Node>();
    private Parser parser;
    private boolean subBlock;

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        if (writer.isPp() && this.getNodes().size() > 1 && !writer.isEscape() && this.getNodes().get(0) instanceof TextNode && this.getNodes().get(1) instanceof TextNode) {
            writer.prettyIndent(1, true);
        }
        for (int i = 0; i < this.getNodes().size(); ++i) {
            if (writer.isPp() && i > 0 && !writer.isEscape() && this.getNodes().get(i) instanceof TextNode && this.getNodes().get(i - 1) instanceof TextNode) {
                writer.prettyIndent(1, false);
            }
            this.getNodes().get(i).execute(writer, model, template);
            Node nextNode = null;
            if (i + 1 < this.getNodes().size()) {
                nextNode = this.getNodes().get(i + 1);
            }
            if (nextNode == null || !(this.getNodes().get(i) instanceof TextNode) || !(nextNode instanceof TextNode)) continue;
            writer.append("\n");
        }
    }

    public void setYield(boolean yield) {
        this.yield = yield;
    }

    public boolean isYield() {
        return this.yield;
    }

    public void setYieldBlock(BlockNode yieldBlock) {
        this.yieldBlock = yieldBlock;
    }

    public BlockNode getYieldBlock() {
        return this.yieldBlock;
    }

    public BlockNode getIncludeBlock() {
        BlockNode ret = null;
        for (Node node : this.getNodes()) {
            if (node instanceof BlockNode && ((BlockNode)node).isYield()) {
                return (BlockNode)node;
            }
            if (node instanceof TagNode && ((TagNode)node).isTextOnly()) continue;
            if (node instanceof BlockNode && ((BlockNode)node).getIncludeBlock() != null) {
                ret = ((BlockNode)node).getIncludeBlock();
            } else if (node.hasBlock()) {
                ret = ((BlockNode)node.getBlock()).getIncludeBlock();
            }
            if (!(ret instanceof BlockNode) || !ret.isYield()) continue;
            return ret;
        }
        return ret;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Collection<? extends Node> getPrepended() {
        return this.prepended;
    }

    public void setPrepended(Collection<? extends Node> prepended) {
        this.prepended = prepended;
    }

    public Collection<? extends Node> getAppended() {
        return this.appended;
    }

    public void setAppended(Collection<? extends Node> appended) {
        this.appended = appended;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setSubBlock(boolean subBlock) {
        this.subBlock = subBlock;
    }

    public boolean isSubBlock() {
        return this.subBlock;
    }
}

