/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.compiler;

import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.ExpressionString;
import de.neuland.jade4j.util.CharacterParser;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class Utils {
    public static Pattern interpolationPattern = Pattern.compile("(\\\\)?([#!])\\{");
    public static CharacterParser characterParser = new CharacterParser();

    public static List<Object> prepareInterpolate(String string, boolean xmlEscape) {
        LinkedList<Object> result = new LinkedList<Object>();
        Matcher matcher = interpolationPattern.matcher(string);
        int start = 0;
        while (matcher.find()) {
            int closingBracketIndex;
            String before = string.substring(start, matcher.start(0));
            if (xmlEscape) {
                before = Utils.escapeHTML(before);
            }
            result.add(before);
            boolean escape = matcher.group(1) != null;
            String flag = matcher.group(2);
            int openBrackets = 1;
            boolean closingBracketFound = false;
            for (closingBracketIndex = matcher.end(); !closingBracketFound && closingBracketIndex < string.length(); ++closingBracketIndex) {
                char currentChar = string.charAt(closingBracketIndex);
                if (currentChar == '{') {
                    ++openBrackets;
                    continue;
                }
                if (currentChar != '}' || --openBrackets != 0) continue;
                closingBracketFound = true;
            }
            String code = string.substring(matcher.end(), closingBracketIndex - 1);
            if (escape) {
                String escapedExpression = string.substring(matcher.start(0), closingBracketIndex).substring(1);
                if (xmlEscape) {
                    escapedExpression = Utils.escapeHTML(escapedExpression);
                }
                result.add(escapedExpression);
            } else {
                ExpressionString expression = new ExpressionString(code);
                if (flag.equals("#")) {
                    expression.setEscape(true);
                }
                result.add(expression);
            }
            start = closingBracketIndex;
        }
        String last = string.substring(start);
        if (xmlEscape) {
            last = Utils.escapeHTML(last);
        }
        result.add(last);
        return result;
    }

    public static String interpolate(List<Object> prepared, JadeModel model, ExpressionHandler expressionHandler) throws ExpressionException {
        StringBuffer result = new StringBuffer();
        for (Object entry : prepared) {
            if (entry instanceof String) {
                result.append(entry);
                continue;
            }
            if (!(entry instanceof ExpressionString)) continue;
            ExpressionString expression = (ExpressionString)entry;
            String stringValue = "";
            String value = expressionHandler.evaluateStringExpression(expression.getValue(), model);
            if (value != null) {
                stringValue = value;
            }
            if (expression.isEscape()) {
                stringValue = Utils.escapeHTML(stringValue);
            }
            result.append(stringValue);
        }
        return result.toString();
    }

    private static String escapeHTML(String string) {
        return StringEscapeUtils.escapeHtml4((String)string);
    }

    public static String interpolate(String string, JadeModel model, boolean escape, ExpressionHandler expressionHandler) throws ExpressionException {
        return Utils.interpolate(Utils.prepareInterpolate(string, escape), model, expressionHandler);
    }
}

