/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.IndentWriter;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Attr;
import de.neuland.jade4j.parser.node.AttrsNode;
import de.neuland.jade4j.parser.node.ConditionalNode;
import de.neuland.jade4j.parser.node.IfConditionNode;
import de.neuland.jade4j.parser.node.MixinBlockNode;
import de.neuland.jade4j.parser.node.MixinNode;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.util.ArgumentSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CallNode
extends AttrsNode {
    protected List<String> arguments = new ArrayList<String>();
    boolean call = false;
    private boolean dynamicMixins = false;

    @Override
    public void execute(IndentWriter writer, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        boolean dynamic;
        boolean bl = dynamic = this.getName().charAt(0) == '#';
        if (dynamic) {
            this.dynamicMixins = true;
        }
        String newname = dynamic ? this.getName().substring(2, this.getName().length() - 1) : '\"' + this.getName() + '\"';
        try {
            newname = (String)template.getExpressionHandler().evaluateExpression(newname, model);
        }
        catch (ExpressionException e) {
            e.printStackTrace();
        }
        MixinNode mixin = dynamic ? model.getMixin(newname) : model.getMixin(this.getName());
        if (mixin == null) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), "mixin " + this.getName() + " is not defined");
        }
        try {
            mixin = (MixinNode)mixin.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        if (this.hasBlock()) {
            List<MixinBlockNode> injectionPoints = this.getInjectionPoints(mixin.getBlock());
            for (MixinBlockNode point : injectionPoints) {
                point.getNodes().add(this.block);
            }
        }
        if (this.isCall()) {
            model.pushScope();
            model.put("block", (Object)this.block);
            this.writeVariables(model, mixin, template);
            this.writeAttributes(model, mixin, template);
            mixin.getBlock().execute(writer, model, template);
            model.put("block", (Object)null);
            model.popScope();
        }
    }

    private List<MixinBlockNode> getInjectionPoints(Node block) {
        ArrayList<MixinBlockNode> result = new ArrayList<MixinBlockNode>();
        for (Node node : block.getNodes()) {
            if (node instanceof MixinBlockNode && !node.hasNodes()) {
                result.add((MixinBlockNode)node);
                continue;
            }
            if (node instanceof ConditionalNode) {
                for (IfConditionNode condition : ((ConditionalNode)node).getConditions()) {
                    result.addAll(this.getInjectionPoints(condition.getBlock()));
                }
                continue;
            }
            if (!node.hasBlock()) continue;
            result.addAll(this.getInjectionPoints(node.getBlock()));
        }
        return result;
    }

    private void writeVariables(JadeModel model, MixinNode mixin, JadeTemplate template) {
        Object value;
        List<String> names = mixin.getArguments();
        List<String> values = this.arguments;
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.size(); ++i) {
            String key = names.get(i);
            value = null;
            if (i < values.size()) {
                value = values.get(i);
            }
            if (value != null) {
                try {
                    value = template.getExpressionHandler().evaluateExpression(values.get(i), model);
                }
                catch (Throwable e) {
                    throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
                }
            }
            if (key == null) continue;
            model.put(key, value);
        }
        if (mixin.getRest() != null) {
            ArrayList<Object> restArguments = new ArrayList<Object>();
            for (int i = names.size(); i < this.arguments.size(); ++i) {
                value = null;
                if (i < values.size()) {
                    value = values.get(i);
                }
                if (value != null) {
                    try {
                        value = template.getExpressionHandler().evaluateExpression(values.get(i), model);
                    }
                    catch (Throwable e) {
                        throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
                    }
                }
                restArguments.add(value);
            }
            model.put(mixin.getRest(), (Object)restArguments);
        }
    }

    private void writeAttributes(JadeModel model, MixinNode mixin, JadeTemplate template) {
        LinkedList<Attr> newAttributes = new LinkedList<Attr>(this.attributes);
        if (this.attributeBlocks.size() > 0) {
            for (String attributeBlock : this.attributeBlocks) {
                Object o = null;
                try {
                    o = template.getExpressionHandler().evaluateExpression(attributeBlock, model);
                }
                catch (ExpressionException e) {
                    e.printStackTrace();
                }
                if (o == null) continue;
                if (o instanceof HashMap) {
                    for (Map.Entry entry : ((HashMap)o).entrySet()) {
                        Attr attr = new Attr((String)entry.getKey(), entry.getValue(), false);
                        newAttributes.add(attr);
                    }
                    continue;
                }
                if (!(o instanceof String)) continue;
                System.out.print(o);
            }
        }
        if (newAttributes.size() > 0) {
            LinkedHashMap<String, String> attrs = this.attrs(model, template, newAttributes);
            model.put("attributes", (Object)attrs);
        } else {
            model.put("attributes", (Object)null);
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setArguments(String arguments) {
        this.arguments.clear();
        this.arguments = ArgumentSplitter.split(arguments);
    }

    public boolean isCall() {
        return this.call;
    }

    public void setCall(boolean call) {
        this.call = call;
    }
}

