/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.compiler;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.io.StringWriter;
import java.io.Writer;

public class Compiler {
    private final Node rootNode;
    private boolean prettyPrint;
    private PugTemplate template = new PugTemplate();

    public Compiler(Node rootNode) {
        this.rootNode = rootNode;
    }

    public String compileToString(PugModel model) throws PugCompilerException {
        StringWriter writer = new StringWriter();
        this.compile(model, writer);
        return writer.toString();
    }

    public void compile(PugModel model, Writer w) throws PugCompilerException {
        IndentWriter writer = new IndentWriter(w);
        writer.setUseIndent(this.prettyPrint);
        this.rootNode.execute(writer, model, this.template);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTemplate(PugTemplate pugTemplate) {
        this.template = pugTemplate;
    }
}

