/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.expression;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.expression.AbstractExpressionHandler;
import de.neuland.pug4j.expression.BooleanUtil;
import de.neuland.pug4j.model.PugModel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalJsExpressionHandler
extends AbstractExpressionHandler {
    final HostAccess all = HostAccess.newBuilder().allowAllImplementations(true).allowPublicAccess(true).allowArrayAccess(true).allowListAccess(true).allowMapAccess(true).targetTypeMapping(Integer.class, Object.class, null, v -> v).targetTypeMapping(Long.class, Object.class, null, v -> v).targetTypeMapping(Float.class, Object.class, null, v -> v).targetTypeMapping(Double.class, Object.class, null, v -> v).targetTypeMapping(Boolean.class, Object.class, null, v -> v).targetTypeMapping(String.class, Object.class, null, v -> v).targetTypeMapping(List.class, Object.class, null, v -> v).targetTypeMapping(Value.class, Object.class, Value::isInstant, Value::asInstant).targetTypeMapping(Value.class, Object.class, Value::isTime, Value::asTime).targetTypeMapping(Value.class, Object.class, Value::isTimeZone, Value::asTimeZone).targetTypeMapping(Value.class, Object.class, Value::isHostObject, Value::asHostObject).targetTypeMapping(Value.class, Object.class, Value::isMetaObject, v -> v).targetTypeMapping(Value.class, Object.class, Value::hasMembers, v -> (Map)v.as(Map.class)).build();
    final Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").allowExperimentalOptions(true).build();
    final ThreadLocal<Map<String, Value>> cacheThreadLocal = ThreadLocal.withInitial(new Supplier<Map<String, Value>>(){

        @Override
        public Map<String, Value> get() {
            return new ConcurrentHashMap<String, Value>();
        }
    });
    final ThreadLocal<Context> contextThreadLocal = ThreadLocal.withInitial(new Supplier<Context>(){

        @Override
        public Context get() {
            Context context = Context.newBuilder((String[])new String[]{"js"}).engine(GraalJsExpressionHandler.this.engine).allowHostAccess(GraalJsExpressionHandler.this.all).allowAllAccess(true).allowHostClassLookup(s -> true).allowCreateThread(false).allowCreateProcess(false).allowPolyglotAccess(PolyglotAccess.ALL).build();
            context.initialize("js");
            return context;
        }
    });

    @Override
    public Boolean evaluateBooleanExpression(String expression, PugModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, PugModel model) throws ExpressionException {
        Context context = this.contextThreadLocal.get();
        Map<String, Value> cache = this.cacheThreadLocal.get();
        try {
            this.saveLocalVariableName(expression, model);
            Value jsContextBindings = context.getBindings("js");
            for (Map.Entry<String, Object> objectEntry : model.entrySet()) {
                String key = objectEntry.getKey();
                if ("pug4j__localVars".equals(key)) continue;
                jsContextBindings.putMember(key, objectEntry.getValue());
            }
            Value eval = cache.get(expression);
            if (eval == null) {
                Source js = expression.startsWith("{") ? Source.create((String)"js", (CharSequence)("(" + expression + ")")) : Source.create((String)"js", (CharSequence)expression);
                eval = context.parse(js);
                cache.put(expression, eval);
            }
            eval = eval.execute(new Object[0]);
            Set memberKeys = jsContextBindings.getMemberKeys();
            for (String memberKey : memberKeys) {
                if (!model.knowsKey(memberKey) || memberKey.startsWith("pug4j__")) continue;
                Value member = jsContextBindings.getMember(memberKey);
                model.put(memberKey, member.as(Object.class));
                try {
                    jsContextBindings.removeMember(memberKey);
                }
                catch (UnsupportedOperationException e) {
                    jsContextBindings.putMember(memberKey, null);
                }
            }
            Object object = eval.as(Object.class);
            return object;
        }
        catch (Exception ex) {
            block10: {
                if (ex.getMessage() == null || !ex.getMessage().startsWith("ReferenceError:")) break block10;
                Object var6_8 = null;
                return var6_8;
            }
            throw new ExpressionException(expression, ex);
        }
    }

    @Override
    public String evaluateStringExpression(String expression, PugModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        block2: {
            Context context = this.contextThreadLocal.get();
            Source js = expression.startsWith("{") ? Source.create((String)"js", (CharSequence)("(" + expression + ")")) : Source.create((String)"js", (CharSequence)expression);
            try {
                Value value = context.eval(js);
            }
            catch (PolyglotException e) {
                if (!e.getMessage().startsWith("SyntaxError:")) break block2;
                throw new ExpressionException(e.getMessage());
            }
        }
    }

    @Override
    public void setCache(boolean cache) {
    }

    @Override
    public void clearCache() {
    }

    public Context getContext() {
        return this.contextThreadLocal.get();
    }
}

