/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.model;

import de.neuland.pug4j.filter.Filter;
import de.neuland.pug4j.parser.node.MixinNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PugModel
implements Map<String, Object> {
    private static final String LOCALS = "locals";
    public static final String LOCAL_VARS = "pug4j__localVars";
    public static final String PUG4J_MODEL_PREFIX = "pug4j__";
    private Deque<Map<String, Object>> scopes = new LinkedList<Map<String, Object>>();
    private Map<String, MixinNode> mixins = new HashMap<String, MixinNode>();
    private Map<String, Filter> filter = new HashMap<String, Filter>();

    public PugModel(Map<String, Object> defaults) {
        this.pushScope();
        if (defaults != null) {
            this.putAll((Map<? extends String, ? extends Object>)defaults);
        }
        this.putLocal(LOCALS, this);
    }

    public void pushScope() {
        HashMap scope = new HashMap();
        scope.put(LOCAL_VARS, new HashSet());
        this.scopes.add(scope);
    }

    public void popScope() {
        this.scopes.removeLast();
    }

    public void setMixin(String name, MixinNode node) {
        this.mixins.put(name, node);
    }

    public MixinNode getMixin(String name) {
        return this.mixins.get(name);
    }

    @Override
    public void clear() {
        this.scopes.clear();
        this.scopes.add(new HashMap());
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean knowsKey(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            Set localVars = (Set)scope.get(LOCAL_VARS);
            if (!scope.containsKey(key) && !localVars.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.keySet()) {
            map.put(key, this.get(key));
        }
        return map.entrySet();
    }

    @Override
    public Object get(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            return scope.get(key);
        }
        return null;
    }

    private Map<String, Object> getScopeWithKey(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            Set localVars = (Set)scope.get(LOCAL_VARS);
            if (!scope.containsKey(key) && !localVars.contains(key)) continue;
            return scope;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            keys.addAll(i.next().keySet());
        }
        return keys;
    }

    @Override
    public Object put(String key, Object value) {
        Set<String> localVars = this.getLocalVars();
        if (localVars.contains(key)) {
            return this.putLocal(key, value);
        }
        return this.putGlobal(key, value);
    }

    private Set<String> getLocalVars() {
        return (Set)this.scopes.getLast().get(LOCAL_VARS);
    }

    public Object putLocal(String key, Object value) {
        Object currentValue = this.get(key);
        Map<String, Object> scope = this.scopes.getLast();
        scope.put(key, value);
        return currentValue;
    }

    public Object putGlobal(String key, Object value) {
        Object currentValue = this.get(key);
        Map<String, Object> scope = this.getScopeWithKey(key);
        if (scope == null) {
            scope = this.scopes.getLast();
        }
        scope.put(key, value);
        return currentValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.scopes.getLast().putAll(m);
    }

    @Override
    public Object remove(Object key) {
        Iterator<Map<String, Object>> i = this.scopes.descendingIterator();
        while (i.hasNext()) {
            Map<String, Object> scope = i.next();
            if (!scope.containsKey(key)) continue;
            Object object = scope.get(key);
            scope.remove(key);
            return object;
        }
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    public Filter getFilter(String name) {
        return this.filter.get(name);
    }

    public void addFilter(String name, Filter filter) {
        this.filter.put(name, filter);
    }

    public void putLocalVariableName(String name) {
        this.getLocalVars().add(name);
    }
}

