/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.template;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import de.neuland.pug4j.template.FileTemplateLoader;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Paths;

public class ClasspathTemplateLoader
implements TemplateLoader {
    private final FileTemplateLoader fileTemplateLoader;

    private String getResourcePath(String path) {
        try {
            return Paths.get(Thread.currentThread().getContextClassLoader().getResource(path).toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw new PugTemplateLoaderException("Path '" + path + "' does not exist.");
        }
    }

    public ClasspathTemplateLoader() {
        String path = this.getResourcePath("");
        this.fileTemplateLoader = new FileTemplateLoader(path);
    }

    public ClasspathTemplateLoader(Charset encoding) {
        String path = this.getResourcePath("");
        this.fileTemplateLoader = new FileTemplateLoader(path, encoding);
    }

    public ClasspathTemplateLoader(Charset encoding, String extension) {
        String path = this.getResourcePath("");
        this.fileTemplateLoader = new FileTemplateLoader(path, encoding, extension);
    }

    public ClasspathTemplateLoader(String templateLoaderPath) {
        String path = this.getResourcePath(templateLoaderPath);
        this.fileTemplateLoader = new FileTemplateLoader(path);
    }

    public ClasspathTemplateLoader(String templateLoaderPath, Charset encoding) {
        String path = this.getResourcePath(templateLoaderPath);
        this.fileTemplateLoader = new FileTemplateLoader(path, encoding);
    }

    public ClasspathTemplateLoader(String templateLoaderPath, String extension) {
        String path = this.getResourcePath(templateLoaderPath);
        this.fileTemplateLoader = new FileTemplateLoader(path, extension);
    }

    public ClasspathTemplateLoader(String templateLoaderPath, Charset encoding, String extension) {
        String path = this.getResourcePath(templateLoaderPath);
        this.fileTemplateLoader = new FileTemplateLoader(path, encoding, extension);
    }

    @Override
    public long getLastModified(String name) {
        return -1L;
    }

    @Override
    public Reader getReader(String name) throws IOException {
        return this.fileTemplateLoader.getReader(name);
    }

    @Override
    public String getExtension() {
        return this.fileTemplateLoader.getExtension();
    }

    @Override
    public String getBase() {
        return this.fileTemplateLoader.getBase();
    }

    public void setBase(String basePath) {
        this.fileTemplateLoader.setBase(basePath);
    }
}

