/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArgumentSplitter {
    private static final char ARGUMENT_DELIMITER = ',';
    private final String arguments;
    private List<String> argList = new ArrayList<String>();

    public static List<String> split(String arguments) {
        if (arguments == null) {
            return Collections.emptyList();
        }
        return new ArgumentSplitter(arguments).splitArguments();
    }

    private ArgumentSplitter(String arguments) {
        this.arguments = arguments;
    }

    private List<String> splitArguments() {
        int argLength = this.arguments.length();
        StringBuilder builder = new StringBuilder(argLength);
        boolean insideQuotas = false;
        int bracesBlock = 0;
        for (int i = 0; i < argLength; ++i) {
            char ch = this.arguments.charAt(i);
            if (this.isQuoted(ch)) {
                insideQuotas = !insideQuotas;
            } else if (this.isOpeningBraces(ch)) {
                ++bracesBlock;
            } else if (this.isClosingBraces(ch)) {
                --bracesBlock;
            } else if (ch == ',' && !insideQuotas && bracesBlock == 0) {
                this.addArgument(builder.toString());
                builder = new StringBuilder(argLength - i);
            }
            builder.append(ch);
        }
        this.addArgument(builder.toString());
        return this.argList;
    }

    private boolean isClosingBraces(char ch) {
        return ch == ')' || ch == ']' || ch == '}';
    }

    private boolean isOpeningBraces(char ch) {
        return ch == '(' || ch == '[' || ch == '{';
    }

    private boolean isQuoted(char ch) {
        return ch == '\"' || ch == '\'';
    }

    private void addArgument(String argument) {
        this.argList.add(argument.trim().replaceAll("^,", "").trim());
    }
}

