/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.compiler;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;

public class IndentWriter {
    private int indent = 0;
    private boolean useIndent = false;
    private Writer writer;
    private String pp = "  ";
    private boolean escape;

    public IndentWriter(Writer writer) {
        this.writer = writer;
    }

    public IndentWriter add(String string) {
        return this.append(string);
    }

    public IndentWriter append(String string) {
        this.write(string);
        return this;
    }

    public void increment() {
        ++this.indent;
    }

    public void decrement() {
        --this.indent;
    }

    private void write(String string) {
        try {
            this.writer.write(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public void newline() {
        if (this.isPp()) {
            this.write("\n" + StringUtils.repeat((String)"  ", (int)this.indent));
        }
    }

    public void prettyIndent(int offset, boolean newline) {
        if (this.isPp()) {
            String newlineChar = newline ? "\n" : "";
            this.write(newlineChar + StringUtils.repeat((String)this.pp, (int)(this.indent + offset - 1)));
        }
    }

    public void setUseIndent(boolean useIndent) {
        this.useIndent = useIndent;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public boolean isPp() {
        return this.pp.length() != 0 && this.useIndent;
    }
}

