/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.exceptions;

import de.neuland.pug4j.Pug4J;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class PugException
extends RuntimeException {
    private static final long serialVersionUID = -8189536050437574552L;
    private String filename;
    private int lineNumber;
    private int colNumber;
    private TemplateLoader templateLoader;

    protected PugException(String message, String filename, int lineNumber, TemplateLoader templateLoader, Throwable e) {
        super(message, e);
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.templateLoader = templateLoader;
    }

    protected PugException(String message, String filename, int lineNumber, int column, TemplateLoader templateLoader, Throwable e) {
        super(message, e);
        this.filename = filename;
        this.lineNumber = lineNumber;
        this.colNumber = column;
        this.templateLoader = templateLoader;
    }

    protected PugException(String message) {
        super(message);
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    private String createErrorMessage(String message, int line, int column, String filename) {
        String fullMessage;
        String location = line + (column != 0 ? ":" + column : "");
        List<String> lines = this.getTemplateLines();
        if (lines != null && lines.size() > 0 && line >= 1 && line <= lines.size()) {
            int start = Math.max(line - 3, 0);
            int end = Math.min(lines.size(), line + 3);
            StringBuffer context = new StringBuffer();
            for (int i = start; i < end; ++i) {
                String text = lines.get(i);
                int curr = i + 1;
                String preamble = (curr == line ? "  > " : "    ") + curr + "| ";
                String out = preamble + text;
                if (curr == line && column > 0) {
                    out = out + "\n";
                    out = out + StringUtils.repeat((String)"-", (int)(preamble.length() + column - 1)) + "^";
                }
                context.append(out);
                if (i == end - 1) continue;
                context.append("\n");
            }
            fullMessage = filename + ":" + location + "\n" + context.toString() + "\n\n" + message;
        } else {
            fullMessage = filename + ":" + location + "\n\n" + message;
        }
        return fullMessage;
    }

    public List<String> getTemplateLines() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            Reader reader = this.templateLoader.getReader(this.filename);
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                result.add(line);
            }
            return result;
        }
        catch (Exception e) {
            return result;
        }
    }

    @Override
    public String toString() {
        return this.getClass() + ": " + this.createErrorMessage(this.getMessage(), this.lineNumber, this.colNumber, this.filename);
    }

    public String toHtmlString() {
        return this.toHtmlString(null);
    }

    public String toHtmlString(String generatedHtml) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filename", this.filename);
        model.put("linenumber", this.lineNumber);
        model.put("column", this.colNumber);
        model.put("message", this.getMessage());
        model.put("lines", this.getTemplateLines());
        model.put("exception", this.getName());
        if (generatedHtml != null) {
            model.put("html", generatedHtml);
        }
        try {
            URL url = PugException.class.getResource("/error.jade");
            return Pug4J.render(url, model, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getName() {
        return this.getClass().getSimpleName().replaceAll("([A-Z])", " $1").trim();
    }
}

