/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.jexl3.internal;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Frame;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTMethodNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Token;

public class PugJexlInterpreter
extends Interpreter {
    protected PugJexlInterpreter(Engine engine, JexlOptions opts, JexlContext aContext, Frame eFrame) {
        super(engine, opts, aContext, eFrame);
    }

    protected Object visit(ASTReference node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        for (int c = 0; c < numChildren; ++c) {
            JexlNode childNode = node.jjtGetChild(c);
            if (!(childNode instanceof ASTMethodNode) || node.jjtGetChild(0) == childNode || (!(node.jjtGetChild(0) instanceof ASTIdentifier) || this.context.get(((ASTIdentifier)node.jjtGetChild(0)).getName()) != null) && node.jjtGetChild(0) instanceof ASTIdentifier) continue;
            this.addExceptionInfoTo(childNode);
            throw new JexlException(childNode, "attempting to call method on null");
        }
        return super.visit(node, data);
    }

    private void addExceptionInfoTo(JexlNode childNode) {
        JexlInfo info = this.createInfo();
        childNode.jjtSetValue((Object)info);
        Token t = new Token();
        t.beginLine = info.getLine();
        t.endLine = 0;
        childNode.jjtSetFirstToken(t);
    }

    private JexlInfo createInfo() {
        JexlInfo info = null;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement se = null;
        String name = ((Object)((Object)this)).getClass().getName();
        for (int s = 1; s < stack.length; ++s) {
            se = stack[s];
            String className = se.getClassName();
            if (className.equals(name)) continue;
            if (!className.startsWith("org.apache.commons.jexl3.")) break;
            name = className;
        }
        if (se != null) {
            info = this.jexl.createInfo(se.getClassName() + "." + se.getMethodName(), se.getLineNumber(), 0);
        }
        return info;
    }
}

