/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import com.google.gson.Gson;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Attr;
import de.neuland.pug4j.parser.node.ExpressionString;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public abstract class AttrsNode
extends Node {
    private static final String[] selfClosingTags = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"};
    protected LinkedList<Attr> attributes = new LinkedList();
    protected LinkedList<String> attributeBlocks = new LinkedList();
    protected List<String> attributeNames = new LinkedList<String>();
    protected boolean selfClosing = false;
    protected Node codeNode;
    private boolean textOnly;
    private static Gson gson = new Gson();

    public AttrsNode setAttribute(String key, Object value, boolean escaped) {
        if (!"class".equals(key) && this.attributeNames.indexOf(key) != -1) {
            throw new Error("Duplicate attribute '" + key + "' is not allowed.");
        }
        this.attributeNames.add(key);
        Attr attr = new Attr(key, value, escaped);
        this.attributes.add(attr);
        return this;
    }

    @Override
    public AttrsNode clone() throws CloneNotSupportedException {
        AttrsNode clone = (AttrsNode)super.clone();
        if (this.attributes != null) {
            clone.attributes = new LinkedList<Attr>(this.attributes);
        }
        if (this.attributes != null) {
            clone.attributeBlocks = new LinkedList<String>(this.attributeBlocks);
        }
        return clone;
    }

    public void addAttributes(String src) {
        this.attributeBlocks.add(src);
    }

    public void setSelfClosing(boolean selfClosing) {
        this.selfClosing = selfClosing;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public void setCodeNode(Node codeNode) {
        this.codeNode = codeNode;
    }

    public Node getCodeNode() {
        return this.codeNode;
    }

    public boolean hasCodeNode() {
        return this.codeNode != null;
    }

    protected String visitAttributes(PugModel model, PugTemplate template) {
        LinkedList<Attr> newAttributes = new LinkedList<Attr>(this.attributes);
        if (this.attributeBlocks.size() > 0) {
            for (String attributeBlock : this.attributeBlocks) {
                Object o = null;
                try {
                    o = template.getExpressionHandler().evaluateExpression(attributeBlock, model);
                }
                catch (ExpressionException e) {
                    throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
                }
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                for (Map.Entry entry : map.entrySet()) {
                    Attr attr = new Attr(String.valueOf(entry.getKey()), entry.getValue(), false);
                    newAttributes.add(attr);
                }
            }
            Map<String, String> attrs = this.attrs(model, template, newAttributes);
            return this.attrsToString(attrs);
        }
        Map<String, String> attrs = this.attrs(model, template, newAttributes);
        return this.attrsToString(attrs);
    }

    private String attrsToString(Map<String, String> attrs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            sb.append(" ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) continue;
            sb.append("=").append('\"');
            sb.append(entry.getValue());
            sb.append('\"');
        }
        return sb.toString();
    }

    protected Map<String, String> attrs(PugModel model, PugTemplate template, LinkedList<Attr> attrs) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Boolean> classEscaping = new ArrayList<Boolean>();
        LinkedHashMap<String, String> newAttributes = new LinkedHashMap<String, String>();
        for (Attr attribute : attrs) {
            try {
                this.addAttributesToMap(newAttributes, classes, classEscaping, attribute, model, template);
            }
            catch (ExpressionException e) {
                throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
            }
        }
        LinkedHashMap<String, String> finalAttributes = new LinkedHashMap<String, String>();
        if (!classes.isEmpty()) {
            String out = "";
            for (int i = 0; i < classes.size(); ++i) {
                String classname = classEscaping.get(i) != false ? StringEscapeUtils.escapeHtml4((String)classes.get(i)) : classes.get(i);
                out = i == 0 ? classname : out + " " + classname;
            }
            finalAttributes.put("class", out);
        }
        finalAttributes.putAll(newAttributes);
        return finalAttributes;
    }

    private void addAttributesToMap(Map<String, String> newAttributes, ArrayList<String> classes, ArrayList<Boolean> classEscaping, Attr attribute, PugModel model, PugTemplate template) throws ExpressionException {
        Object expressionValue;
        ExpressionString expressionString;
        String name = attribute.getName();
        boolean escaped = attribute.isEscaped();
        String value = null;
        Object attributeValue = attribute.getValue();
        if ("class".equals(name)) {
            if (attributeValue instanceof String) {
                value = (String)attributeValue;
            } else if (attributeValue instanceof ExpressionString) {
                Object expressionValue2 = this.evaluateExpression((ExpressionString)attributeValue, model, template.getExpressionHandler());
                if (expressionValue2 != null && expressionValue2 instanceof List) {
                    StringBuffer s = new StringBuffer("");
                    List list = (List)expressionValue2;
                    boolean first = true;
                    for (Object o : list) {
                        if (!first) {
                            s.append(" ");
                        }
                        s.append(o.toString());
                        first = false;
                    }
                    value = s.toString();
                } else if (expressionValue2 != null && expressionValue2.getClass().isArray()) {
                    StringBuffer s = new StringBuffer("");
                    boolean first = true;
                    if (expressionValue2 instanceof int[]) {
                        for (int o : (int[])expressionValue2) {
                            if (!first) {
                                s.append(" ");
                            }
                            s.append(o);
                            first = false;
                        }
                    } else {
                        for (Object o : (Object[])expressionValue2) {
                            if (!first) {
                                s.append(" ");
                            }
                            s.append(o.toString());
                            first = false;
                        }
                    }
                    value = s.toString();
                } else if (expressionValue2 != null && expressionValue2 instanceof Map) {
                    Map map = (Map)expressionValue2;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getValue() instanceof Boolean) || !((Boolean)entry.getValue()).booleanValue()) continue;
                        classes.add((String)entry.getKey());
                        classEscaping.add(false);
                    }
                } else if (expressionValue2 != null && expressionValue2 instanceof Boolean) {
                    if (((Boolean)expressionValue2).booleanValue()) {
                        value = expressionValue2.toString();
                    }
                } else if (expressionValue2 != null) {
                    value = expressionValue2.toString();
                }
            }
            if (!StringUtils.isBlank((CharSequence)value)) {
                classes.add(value);
                classEscaping.add(escaped);
            }
            return;
        }
        if ("style".equals(name)) {
            if (attributeValue instanceof ExpressionString) {
                expressionString = (ExpressionString)attributeValue;
                expressionValue = this.evaluateExpression(expressionString, model, template.getExpressionHandler());
                if (expressionValue == null) {
                    return;
                }
                attributeValue = this.style(expressionValue);
            } else {
                attributeValue = this.style(attributeValue);
            }
        }
        if (attributeValue instanceof ExpressionString) {
            expressionString = (ExpressionString)attributeValue;
            expressionValue = this.evaluateExpression(expressionString, model, template.getExpressionHandler());
            if (expressionValue == null) {
                return;
            }
            if (expressionValue instanceof Boolean) {
                Boolean booleanValue = (Boolean)expressionValue;
                if (!booleanValue.booleanValue()) {
                    return;
                }
                value = name;
                if (template.isTerse()) {
                    value = null;
                }
            } else if (expressionValue instanceof Instant) {
                Instant instantValue = (Instant)expressionValue;
                value = instantValue.toString();
            } else {
                value = expressionValue.getClass().isArray() || expressionValue instanceof Map || expressionValue instanceof List ? StringEscapeUtils.unescapeJava((String)gson.toJson(expressionValue)) : expressionValue.toString();
            }
        } else if (attributeValue instanceof String) {
            value = (String)attributeValue;
        } else if (attributeValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)attributeValue;
            if (!booleanValue.booleanValue()) {
                return;
            }
            value = name;
            if (template.isTerse()) {
                value = null;
            }
        }
        if (escaped) {
            value = StringEscapeUtils.escapeHtml4((String)value);
        }
        newAttributes.put(name, value);
    }

    private String style(Object value) {
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return "";
        }
        if (value instanceof Map) {
            String out = "";
            Set entries = ((Map)value).entrySet();
            for (Map.Entry style : entries) {
                out = out + (String)style.getKey() + ":" + (String)style.getValue() + ";";
            }
            return out;
        }
        return String.valueOf(value);
    }

    private Object evaluateExpression(ExpressionString attribute, PugModel model, ExpressionHandler expressionHandler) throws ExpressionException {
        String expression = attribute.getValue();
        Object result = expressionHandler.evaluateExpression(expression, model);
        if (result instanceof ExpressionString) {
            return this.evaluateExpression((ExpressionString)result, model, expressionHandler);
        }
        return result;
    }

    protected boolean isSelfClosingTag() {
        return ArrayUtils.contains((Object[])selfClosingTags, (Object)this.name);
    }

    public LinkedList<Attr> getAttributes() {
        return this.attributes;
    }
}

