/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ResettableIterator;

public class EachNode
extends Node {
    private String key;
    private String code;
    private Node elseNode;

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        Object result;
        try {
            result = template.getExpressionHandler().evaluateExpression(this.getCode(), model);
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
        if (result == null) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), "[" + this.code + "] has to be iterable but was null");
        }
        model.pushScope();
        this.run(writer, model, result, template);
        model.popScope();
    }

    private void run(IndentWriter writer, PugModel model, Object result, PugTemplate template) {
        if (result instanceof Iterable) {
            this.runIterator(((Iterable)result).iterator(), model, writer, template);
        } else if (result.getClass().isArray()) {
            ResettableIterator iterator = IteratorUtils.arrayIterator((Object)result);
            this.runIterator((Iterator<?>)iterator, model, writer, template);
        } else if (result instanceof Map) {
            this.runMap((Map)result, model, writer, template);
        }
    }

    private void runIterator(Iterator<?> iterator, PugModel model, IndentWriter writer, PugTemplate template) {
        int index = 0;
        if (!iterator.hasNext()) {
            this.executeElseNode(model, writer, template);
            return;
        }
        while (iterator.hasNext()) {
            model.putLocal(this.getValue(), iterator.next());
            model.putLocal(this.getKey(), index);
            this.getBlock().execute(writer, model, template);
            ++index;
        }
    }

    private void runMap(Map<Object, Object> result, PugModel model, IndentWriter writer, PugTemplate template) {
        Set<Object> keys = result.keySet();
        if (keys.size() == 0) {
            this.executeElseNode(model, writer, template);
            return;
        }
        for (Object key : keys) {
            model.putLocal(this.getValue(), result.get(key));
            model.putLocal(this.getKey(), key);
            this.getBlock().execute(writer, model, template);
        }
    }

    private void executeElseNode(PugModel model, IndentWriter writer, PugTemplate template) {
        if (this.elseNode != null) {
            this.elseNode.execute(writer, model, template);
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getKey() {
        return this.key == null ? "$index" : this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(Node elseNode) {
        this.elseNode = elseNode;
    }
}

