/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.template;

import de.neuland.pug4j.Pug4J;
import de.neuland.pug4j.compiler.Compiler;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.DoctypeNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.Writer;

public class PugTemplate {
    private boolean prettyPrint = false;
    private Node rootNode;
    private boolean terse = false;
    private boolean xml = false;
    private TemplateLoader templateLoader;
    private ExpressionHandler expressionHandler;

    public PugTemplate() {
    }

    public PugTemplate(Node rootNode) {
        this.setRootNode(rootNode);
    }

    public PugTemplate(Node rootNode, Pug4J.Mode mode) {
        this.setMode(mode);
        this.setRootNode(rootNode);
    }

    public void process(PugModel model, Writer writer) throws PugCompilerException {
        Compiler compiler = new Compiler(this);
        compiler.compile(model, writer);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Node rootNode) {
        Node peek = rootNode.getNodes().peek();
        if (peek instanceof DoctypeNode) {
            DoctypeNode doctypeNode = (DoctypeNode)peek;
            this.setDoctype(doctypeNode.getValue());
        }
        this.rootNode = rootNode;
    }

    public boolean isTerse() {
        return this.terse;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setDoctype(String name) {
        this.terse = "html".equals(name);
        this.xml = "xml".equals(name);
    }

    public void setMode(Pug4J.Mode mode) {
        this.setDoctype(mode.name().toLowerCase());
    }

    public void setExpressionHandler(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }
}

