/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.util;

import de.neuland.pug4j.util.CharacterParserException;
import de.neuland.pug4j.util.Options;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharacterParser {
    private Pattern pattern = Pattern.compile("^\\w+\\b");

    public State parse(String src) {
        Options options = new Options();
        options.setEnd(src.length());
        return this.parse(src, this.defaultState(), options);
    }

    public State parse(String src, State state) {
        Options options = new Options();
        options.setEnd(src.length());
        return this.parse(src, state, options);
    }

    public State parse(String src, State state, Options options) {
        if (options == null) {
            options = new Options();
            options.setEnd(src.length());
        }
        if (state == null) {
            state = this.defaultState();
        }
        int start = options.getStart();
        int end = options.getEnd();
        int index = start;
        while (index < end) {
            try {
                this.parseChar(src.charAt(index++), state);
            }
            catch (StringIndexOutOfBoundsException ex) {
                CharacterParserException characterParserException = new CharacterParserException("Character must be a string of length 1");
                characterParserException.setCode("CHARACTER_PARSER:CHAR_LENGTH_NOT_ONE");
                characterParserException.setIndex(index);
                throw characterParserException;
            }
        }
        return state;
    }

    public Match parseMax(String src) throws SyntaxError {
        Options options = new Options();
        return this.parseMax(src, options);
    }

    public Match parseMax(String src, Options options) throws SyntaxError {
        int start;
        if (options == null) {
            options = new Options();
        }
        int index = start = options.getStart();
        State state = this.defaultState();
        while (state.getRoundDepth() >= 0 && state.getCurlyDepth() >= 0 && state.getSquareDepth() >= 0) {
            if (index >= src.length()) {
                throw new SyntaxError("The end of the string was reached with no closing bracket found.");
            }
            this.parseChar(src.charAt(index++), state);
        }
        int end = index - 1;
        return new Match(start, end, src.substring(start, end));
    }

    private int getStateProp(State state, char bracket) {
        if (')' == bracket) {
            return state.getRoundDepth();
        }
        if ('}' == bracket) {
            return state.getCurlyDepth();
        }
        if (']' == bracket) {
            return state.getSquareDepth();
        }
        return -1;
    }

    public Match parseMaxBracket(String src, char bracket) throws SyntaxError {
        return this.parseMaxBracket(src, bracket, new Options());
    }

    public Match parseMaxBracket(String src, char bracket, Options options) throws SyntaxError {
        int start;
        if (options == null) {
            options = new Options();
        }
        int index = start = options.getStart();
        State state = this.defaultState();
        if (bracket != ')' && bracket != '}' && bracket != ']') {
            throw new SyntaxError("Bracket specified (" + String.valueOf(bracket) + ") is not one of \")\", \"]\", or \"}\"");
        }
        while (this.getStateProp(state, bracket) >= 0) {
            if (index >= src.length()) {
                throw new SyntaxError("The end of the string was reached with no closing bracket \"" + bracket + "\" found.");
            }
            this.parseChar(src.charAt(index++), state);
        }
        int end = index - 1;
        return new Match(start, end, src.substring(start, end));
    }

    public Match parseUntil(String src, String delimiter) {
        return this.parseUntil(src, delimiter, new Options());
    }

    public Match parseUntil(String src, String delimiter, Options options) {
        int start;
        int index;
        if (options == null) {
            options = new Options();
        }
        boolean includeLineComment = options.isIncludeLineComment();
        State state = this.defaultState();
        for (index = start = options.getStart(); index < src.length(); ++index) {
            if ((options.isIgnoreNesting() || !state.isNesting(options)) && this.startsWith(src, delimiter, index)) {
                int end = index;
                return new Match(start, end, src.substring(start, end));
            }
            try {
                this.parseChar(src.charAt(index), state);
                continue;
            }
            catch (StringIndexOutOfBoundsException ex) {
                CharacterParserException characterParserException = new CharacterParserException("Character must be a string of length 1");
                characterParserException.setCode("CHARACTER_PARSER:CHAR_LENGTH_NOT_ONE");
                characterParserException.setIndex(index);
                throw characterParserException;
            }
        }
        CharacterParserException characterParserException = new CharacterParserException("The end of the string was reached with no closing bracket found.");
        characterParserException.setCode("CHARACTER_PARSER:END_OF_STRING_REACHED");
        characterParserException.setIndex(index);
        throw characterParserException;
    }

    public State parseChar(char character, State state) {
        Character lastChar;
        if (state == null) {
            state = this.defaultState();
        }
        state.setSrc(state.getSrc() + character);
        boolean wasComment = state.isBlockComment() || state.isLineComment();
        Character c = lastChar = !state.getHistory().isEmpty() ? Character.valueOf(state.getHistory().charAt(0)) : null;
        if (state.isRegexpStart()) {
            if ('/' == character || '*' == character) {
                state.setRegexp(false);
            }
            state.setRegexpStart(false);
        }
        if (state.isLineComment()) {
            if ('\n' == character) {
                state.setLineComment(false);
            }
        } else if (state.isBlockComment()) {
            if ('*' == state.getLastChar().charValue() && '/' == character) {
                state.setBlockComment(false);
            }
        } else if (state.isSingleQuote()) {
            if ('\'' == character && !state.isEscaped()) {
                state.setSingleQuote(false);
            } else if ('\\' == character && !state.isEscaped()) {
                state.setEscaped(true);
            } else {
                state.setEscaped(false);
            }
        } else if (state.isDoubleQuote()) {
            if ('\"' == character && !state.isEscaped()) {
                state.setDoubleQuote(false);
            } else if ('\\' == character && !state.isEscaped()) {
                state.setEscaped(true);
            } else {
                state.setEscaped(false);
            }
        } else if (state.isTemplateQuote()) {
            if ('`' == character && !state.isEscaped()) {
                state.setTemplateQuote(false);
            } else if ('\\' == character && !state.isEscaped()) {
                state.setEscaped(true);
            } else {
                state.setEscaped(false);
            }
        } else if (state.isRegexp()) {
            if ('/' == character && !state.isEscaped()) {
                state.setRegexp(false);
            } else if ('\\' == character && !state.isEscaped()) {
                state.setRegexp(true);
            } else {
                state.setEscaped(false);
            }
        } else if (lastChar != null && '/' == lastChar.charValue() && '/' == character) {
            state.setHistory(state.getHistory().substring(1));
            state.setLineComment(true);
        } else if (lastChar != null && '/' == lastChar.charValue() && '*' == character) {
            state.setHistory(state.getHistory().substring(1));
            state.setBlockComment(true);
        } else if ('/' == character && !state.getHistory().isEmpty() && this.isRegexp(state.getHistory())) {
            state.setRegexp(true);
            state.setRegexpStart(true);
        } else if ('\'' == character) {
            state.setSingleQuote(true);
        } else if (character == '\"') {
            state.setDoubleQuote(true);
        } else if (character == '`') {
            state.setTemplateQuote(true);
        } else if (character == '(') {
            state.setRoundDepth(state.getRoundDepth() + 1);
        } else if (character == ')') {
            state.setRoundDepth(state.getRoundDepth() - 1);
        } else if (character == '{') {
            state.setCurlyDepth(state.getCurlyDepth() + 1);
        } else if (character == '}') {
            state.setCurlyDepth(state.getCurlyDepth() - 1);
        } else if (character == '[') {
            state.setSquareDepth(state.getSquareDepth() + 1);
        } else if (character == ']') {
            state.setSquareDepth(state.getSquareDepth() - 1);
        }
        if (!(state.isBlockComment() || state.isLineComment() || wasComment)) {
            state.setHistory(character + state.getHistory());
        }
        state.setLastChar(Character.valueOf(character));
        return state;
    }

    public State defaultState() {
        return new State();
    }

    private boolean startsWith(String str, String start, int i) {
        return start.equals(str.substring(i, i + start.length()));
    }

    public boolean isPunctuator(Character character) {
        Integer code = Character.codePointAt(character.toString(), 0);
        switch (code) {
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 91: 
            case 93: 
            case 94: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyword(String id) {
        return "if".equals(id) || "in".equals(id) || "do".equals(id) || "var".equals(id) || "for".equals(id) || "new".equals(id) || "try".equals(id) || "let".equals(id) || "this".equals(id) || "else".equals(id) || "case".equals(id) || "void".equals(id) || "with".equals(id) || "enum".equals(id) || "while".equals(id) || "break".equals(id) || "catch".equals(id) || "throw".equals(id) || "const".equals(id) || "yield".equals(id) || "class".equals(id) || "super".equals(id) || "return".equals(id) || "typeof".equals(id) || "delete".equals(id) || "switch".equals(id) || "export".equals(id) || "import".equals(id) || "default".equals(id) || "finally".equals(id) || "extends".equals(id) || "function".equals(id) || "continue".equals(id) || "debugger".equals(id) || "package".equals(id) || "private".equals(id) || "interface".equals(id) || "instanceof".equals(id) || "implements".equals(id) || "protected".equals(id) || "public".equals(id) || "static".equals(id);
    }

    public boolean isRegexp(String history) {
        if ((history = history.replace("^\\s*", "")).charAt(0) == ')') {
            return false;
        }
        if (history.charAt(0) == '}') {
            return true;
        }
        if (this.isPunctuator(Character.valueOf(history.charAt(0)))) {
            return true;
        }
        Matcher matcher = this.pattern.matcher(history);
        return matcher.matches() && this.isKeyword(new StringBuilder(matcher.group(0)).reverse().toString());
    }

    public class Match {
        private int start;
        private int end;
        private String src;

        public Match(int start, int end, String src) {
            this.start = start;
            this.end = end;
            this.src = src;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getSrc() {
            return this.src;
        }
    }

    public static class State {
        private boolean lineComment = false;
        private boolean blockComment = false;
        private boolean singleQuote = false;
        private boolean doubleQuote = false;
        private boolean templateQuote = false;
        private boolean regexp = false;
        private boolean regexpStart = false;
        private boolean escaped = false;
        private int roundDepth = 0;
        private int curlyDepth = 0;
        private int squareDepth = 0;
        private String history = "";
        private Character lastChar = null;
        private String src = "";

        public boolean isString() {
            return this.singleQuote || this.doubleQuote || this.templateQuote;
        }

        public boolean isComment() {
            return this.lineComment || this.blockComment;
        }

        public boolean isNesting(Options options) {
            return this.isString() || this.isComment() || this.regexp || this.roundDepth > 0 || this.curlyDepth > 0 || this.squareDepth > 0;
        }

        public boolean isNesting() {
            return this.isString() || this.isComment() || this.regexp || this.roundDepth > 0 || this.curlyDepth > 0 || this.squareDepth > 0;
        }

        public String getSrc() {
            return this.src;
        }

        public boolean isLineComment() {
            return this.lineComment;
        }

        public void setLineComment(boolean lineComment) {
            this.lineComment = lineComment;
        }

        public boolean isBlockComment() {
            return this.blockComment;
        }

        public void setBlockComment(boolean blockComment) {
            this.blockComment = blockComment;
        }

        public boolean isSingleQuote() {
            return this.singleQuote;
        }

        public void setSingleQuote(boolean singleQuote) {
            this.singleQuote = singleQuote;
        }

        public boolean isDoubleQuote() {
            return this.doubleQuote;
        }

        public void setDoubleQuote(boolean doubleQuote) {
            this.doubleQuote = doubleQuote;
        }

        public boolean isTemplateQuote() {
            return this.templateQuote;
        }

        public void setTemplateQuote(boolean templateQuote) {
            this.templateQuote = templateQuote;
        }

        public boolean isRegexp() {
            return this.regexp;
        }

        public void setRegexp(boolean regexp) {
            this.regexp = regexp;
        }

        public boolean isRegexpStart() {
            return this.regexpStart;
        }

        public void setRegexpStart(boolean regexpStart) {
            this.regexpStart = regexpStart;
        }

        public boolean isEscaped() {
            return this.escaped;
        }

        public void setEscaped(boolean escaped) {
            this.escaped = escaped;
        }

        public int getRoundDepth() {
            return this.roundDepth;
        }

        public void setRoundDepth(int roundDepth) {
            this.roundDepth = roundDepth;
        }

        public int getCurlyDepth() {
            return this.curlyDepth;
        }

        public void setCurlyDepth(int curlyDepth) {
            this.curlyDepth = curlyDepth;
        }

        public int getSquareDepth() {
            return this.squareDepth;
        }

        public void setSquareDepth(int squareDepth) {
            this.squareDepth = squareDepth;
        }

        public String getHistory() {
            return this.history;
        }

        public void setHistory(String history) {
            this.history = history;
        }

        public Character getLastChar() {
            return this.lastChar;
        }

        public void setLastChar(Character lastChar) {
            this.lastChar = lastChar;
        }

        public void setSrc(String src) {
            this.src = src;
        }
    }

    public static class SyntaxError
    extends Exception {
        public SyntaxError(String message) {
            super(message);
        }
    }
}

