/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.util;

import de.neuland.pug4j.util.StringReplacer;
import de.neuland.pug4j.util.StringReplacerCallback;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PugEscape {
    public static HashMap<String, String> pug_encode_html_rules = new HashMap();
    static Pattern pug_match_html;

    private static String pug_encode_char(String c) {
        String s = pug_encode_html_rules.get(c);
        if (s == null) {
            return c;
        }
        return s;
    }

    public static String escape(String html) {
        String result = StringReplacer.replace(html, pug_match_html, new StringReplacerCallback(){

            @Override
            public String replace(Matcher m) {
                return PugEscape.pug_encode_char(m.group(0));
            }
        });
        return result;
    }

    static {
        pug_encode_html_rules.put("&", "&amp;");
        pug_encode_html_rules.put("<", "&lt;");
        pug_encode_html_rules.put(">", "&gt;");
        pug_encode_html_rules.put("\"", "&quot;");
        pug_match_html = Pattern.compile("[&<>\"]");
    }
}

