/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.compiler;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.io.StringWriter;
import java.io.Writer;

public class Compiler {
    private PugTemplate template;

    public Compiler(PugTemplate pugTemplate) {
        this.template = pugTemplate;
    }

    public Compiler(Node rootNode) {
        this.template = new PugTemplate(rootNode);
    }

    public String compileToString(PugModel model) throws PugCompilerException {
        StringWriter writer = new StringWriter();
        this.compile(model, writer);
        return writer.toString();
    }

    public void compile(PugModel model, Writer w) throws PugCompilerException {
        IndentWriter writer = new IndentWriter(w);
        writer.setUseIndent(this.template.isPrettyPrint());
        this.template.getRootNode().execute(writer, model, this.template);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.template.setPrettyPrint(prettyPrint);
    }

    public void setTemplate(PugTemplate pugTemplate) {
        this.template = pugTemplate;
    }
}

