/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import com.google.gson.Gson;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Attr;
import de.neuland.pug4j.parser.node.ExpressionString;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public abstract class AttrsNode
extends Node {
    private static final String[] selfClosingTags = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"};
    protected LinkedList<Attr> attributes = new LinkedList();
    protected LinkedList<String> attributeBlocks = new LinkedList();
    protected List<String> attributeNames = new LinkedList<String>();
    protected boolean selfClosing = false;
    protected Node codeNode;
    private boolean textOnly;
    private static Gson gson = new Gson();

    public AttrsNode setAttribute(String key, Object value, boolean escaped) {
        if (!"class".equals(key) && this.attributeNames.indexOf(key) != -1) {
            throw new Error("Duplicate attribute '" + key + "' is not allowed.");
        }
        this.attributeNames.add(key);
        Attr attr = new Attr(key, value, escaped);
        this.attributes.add(attr);
        return this;
    }

    @Override
    public AttrsNode clone() throws CloneNotSupportedException {
        AttrsNode clone = (AttrsNode)super.clone();
        if (this.attributes != null) {
            clone.attributes = new LinkedList<Attr>(this.attributes);
        }
        if (this.attributes != null) {
            clone.attributeBlocks = new LinkedList<String>(this.attributeBlocks);
        }
        return clone;
    }

    public void addAttributes(String src) {
        this.attributeBlocks.add(src);
    }

    public void setSelfClosing(boolean selfClosing) {
        this.selfClosing = selfClosing;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public void setCodeNode(Node codeNode) {
        this.codeNode = codeNode;
    }

    public Node getCodeNode() {
        return this.codeNode;
    }

    public boolean hasCodeNode() {
        return this.codeNode != null;
    }

    protected String visitAttributes(PugModel model, PugTemplate template) {
        LinkedList<Attr> attributesList = new LinkedList<Attr>(this.attributes);
        if (this.attributeBlocks.size() > 0) {
            for (String attributeBlockExpression : this.attributeBlocks) {
                this.addAttributesBlockToAttributesList(model, template, attributeBlockExpression, attributesList);
            }
        }
        Map<String, String> attrs = this.attrs(model, template, attributesList);
        return this.attrsToString(attrs);
    }

    private void addAttributesBlockToAttributesList(PugModel model, PugTemplate template, String attributeBlockExpression, LinkedList<Attr> newAttributes) {
        Object attributesBlock = null;
        try {
            attributesBlock = template.getExpressionHandler().evaluateExpression(attributeBlockExpression, model);
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
        if (attributesBlock instanceof Map) {
            Map map = (Map)attributesBlock;
            for (Map.Entry entry : map.entrySet()) {
                Attr attr = new Attr(String.valueOf(entry.getKey()), entry.getValue(), false);
                newAttributes.add(attr);
            }
        } else {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), "attribute block '" + attributeBlockExpression + "' is not a Map");
        }
    }

    private String attrsToString(Map<String, String> attrs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            sb.append(" ");
            sb.append(entry.getKey());
            if (entry.getValue() == null) continue;
            sb.append("=").append('\"');
            sb.append(entry.getValue());
            sb.append('\"');
        }
        return sb.toString();
    }

    protected Map<String, String> attrs(PugModel model, PugTemplate template, LinkedList<Attr> attrs) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Boolean> classEscaping = new ArrayList<Boolean>();
        LinkedHashMap<String, String> normalAttributes = new LinkedHashMap<String, String>();
        for (Attr attribute : attrs) {
            this.createAttributeValues(normalAttributes, classes, classEscaping, attribute, model, template);
        }
        LinkedHashMap<String, String> finalAttributes = new LinkedHashMap<String, String>();
        if (!classes.isEmpty()) {
            String classList = this.renderClassList(classes, classEscaping);
            finalAttributes.put("class", classList);
        }
        finalAttributes.putAll(normalAttributes);
        return finalAttributes;
    }

    private String renderClassList(ArrayList<String> classes, ArrayList<Boolean> classEscaping) {
        StringBuilder classList = new StringBuilder();
        for (int i = 0; i < classes.size(); ++i) {
            Boolean escaped = classEscaping.get(i);
            String className = escaped != false ? StringEscapeUtils.escapeHtml4((String)classes.get(i)) : classes.get(i);
            if (i > 0) {
                classList.append(" ");
            }
            classList.append(className);
        }
        return classList.toString();
    }

    private void createAttributeValues(Map<String, String> newAttributes, ArrayList<String> classes, ArrayList<Boolean> classEscaping, Attr attribute, PugModel model, PugTemplate template) {
        String name = attribute.getName();
        boolean escaped = attribute.isEscaped();
        String value = null;
        Object attributeValue = attribute.getValue();
        if (attributeValue instanceof ExpressionString) {
            ExpressionString expressionString = (ExpressionString)attributeValue;
            attributeValue = this.evaluateExpression(expressionString, model, template);
        }
        if (this.skipAttribute(attributeValue).booleanValue()) {
            return;
        }
        if ("class".equals(name)) {
            this.addClassValueToClassArray(classes, classEscaping, attributeValue, escaped);
            return;
        }
        value = "style".equals(name) ? this.renderStyleValue(attributeValue) : this.renderNormalValue(template, attributeValue, name);
        if (escaped) {
            value = StringEscapeUtils.escapeHtml4((String)value);
        }
        newAttributes.put(name, value);
    }

    private Boolean skipAttribute(Object attributeValue) {
        Boolean skipAttribute = false;
        if (attributeValue == null) {
            skipAttribute = true;
        }
        if (attributeValue instanceof Boolean && !((Boolean)attributeValue).booleanValue()) {
            skipAttribute = true;
        }
        return skipAttribute;
    }

    private String renderNormalValue(PugTemplate template, Object attributeValue, String name) {
        String value = null;
        if (attributeValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)attributeValue;
            if (booleanValue.booleanValue()) {
                value = name;
            }
            if (template.isTerse()) {
                value = null;
            }
        } else if (attributeValue instanceof Instant) {
            Instant instantValue = (Instant)attributeValue;
            value = instantValue.toString();
        } else if (attributeValue != null && (attributeValue.getClass().isArray() || attributeValue instanceof Map || attributeValue instanceof List)) {
            value = StringEscapeUtils.unescapeJava((String)gson.toJson(attributeValue));
        } else if (attributeValue instanceof String) {
            value = (String)attributeValue;
        } else if (attributeValue != null) {
            value = attributeValue.toString();
        }
        return value;
    }

    private void addClassValueToClassArray(ArrayList<String> classes, ArrayList<Boolean> classEscaping, Object attributeValue, boolean escaped) {
        String value = null;
        if (attributeValue instanceof List) {
            List list = (List)attributeValue;
            for (Object o : list) {
                classes.add(o.toString());
                classEscaping.add(escaped);
            }
        } else if (attributeValue != null && attributeValue.getClass().isArray()) {
            if (attributeValue instanceof int[]) {
                for (int o : (int[])attributeValue) {
                    classes.add(String.valueOf(o));
                    classEscaping.add(escaped);
                }
            } else {
                for (Object o : (Object[])attributeValue) {
                    classes.add(o.toString());
                    classEscaping.add(escaped);
                }
            }
        } else if (attributeValue instanceof Map) {
            Map map = (Map)attributeValue;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof Boolean) || !((Boolean)entry.getValue()).booleanValue()) continue;
                classes.add((String)entry.getKey());
                classEscaping.add(false);
            }
        } else if (attributeValue instanceof Boolean) {
            if (((Boolean)attributeValue).booleanValue()) {
                value = attributeValue.toString();
            }
        } else if (attributeValue != null) {
            value = attributeValue.toString();
        }
        if (!StringUtils.isBlank(value)) {
            classes.add(value);
            classEscaping.add(escaped);
        }
    }

    private String renderStyleValue(Object value) {
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            return "";
        }
        if (value instanceof Map) {
            StringBuilder out = new StringBuilder();
            Set entries = ((Map)value).entrySet();
            for (Map.Entry style : entries) {
                out.append((String)style.getKey()).append(":").append((String)style.getValue()).append(";");
            }
            return out.toString();
        }
        return String.valueOf(value);
    }

    private Object evaluateExpression(ExpressionString attribute, PugModel model, PugTemplate pugTemplate) {
        String expression = attribute.getValue();
        try {
            return pugTemplate.getExpressionHandler().evaluateExpression(expression, model);
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, pugTemplate.getTemplateLoader(), e);
        }
    }

    protected boolean isSelfClosingTag() {
        return ArrayUtils.contains((Object[])selfClosingTags, (Object)this.name);
    }

    public LinkedList<Attr> getAttributes() {
        return this.attributes;
    }
}

