/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.Parser;
import de.neuland.pug4j.parser.node.ExpressionNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.parser.node.TagNode;
import de.neuland.pug4j.template.PugTemplate;

public class BlockNode
extends Node {
    private boolean yield = false;
    private String mode;
    private Parser parser;
    private boolean namedBlock;

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        if (writer.isPp() && this.getNodes().size() > 1 && !writer.isEscape() && this.isTextNode(this.getNodes().get(0)) && this.isTextNode(this.getNodes().get(1))) {
            writer.prettyIndent(1, true);
        }
        String bufferedExpressionString = "";
        for (int i = 0; i < this.getNodes().size(); ++i) {
            Node node = this.getNodes().get(i);
            if (writer.isPp() && i > 0 && !writer.isEscape() && this.isTextNode(node) && this.isTextNode(this.getNodes().get(i - 1)) && this.getNodes().get(i - 1).getValue() != null && this.getNodes().get(i - 1).getValue().contains("\n")) {
                writer.prettyIndent(1, false);
            }
            if (node instanceof ExpressionNode && (node.hasBlock() || node.getValue().trim().startsWith("}"))) {
                ((ExpressionNode)node).setBufferedExpressionString(bufferedExpressionString);
            }
            node.execute(writer, model, template);
            if (node instanceof ExpressionNode && (node.hasBlock() || node.getValue().trim().startsWith("}"))) {
                bufferedExpressionString = ((ExpressionNode)node).getBufferedExpressionString();
            }
            Node nextNode = null;
            if (i + 1 < this.getNodes().size()) {
                nextNode = this.getNodes().get(i + 1);
            }
            if (bufferedExpressionString.length() <= 0 || nextNode != null && nextNode != null && nextNode instanceof ExpressionNode && (nextNode.hasBlock() || nextNode.getValue().trim().startsWith("}"))) continue;
            try {
                template.getExpressionHandler().evaluateExpression(bufferedExpressionString, model);
            }
            catch (ExpressionException e) {
                throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
            }
            bufferedExpressionString = "";
        }
    }

    public void setYield(boolean yield) {
        this.yield = yield;
    }

    public boolean isYield() {
        return this.yield;
    }

    public BlockNode getYieldBlock() {
        BlockNode ret = this;
        for (Node node : this.getNodes()) {
            if (node instanceof BlockNode && ((BlockNode)node).isYield()) {
                return (BlockNode)node;
            }
            if (node instanceof TagNode && ((TagNode)node).isTextOnly()) continue;
            if (node instanceof BlockNode && ((BlockNode)node).getYieldBlock() != null) {
                ret = ((BlockNode)node).getYieldBlock();
            } else if (node.hasBlock()) {
                ret = ((BlockNode)node.getBlock()).getYieldBlock();
            }
            if (!(ret instanceof BlockNode) || !ret.isYield()) continue;
            return ret;
        }
        return ret;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean isNamedBlock() {
        return this.namedBlock;
    }

    public void setNamedBlock(boolean namedBlock) {
        this.namedBlock = namedBlock;
    }
}

