/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Attr;
import de.neuland.pug4j.parser.node.AttrsNode;
import de.neuland.pug4j.parser.node.ConditionalNode;
import de.neuland.pug4j.parser.node.IfConditionNode;
import de.neuland.pug4j.parser.node.MixinBlockNode;
import de.neuland.pug4j.parser.node.MixinNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import de.neuland.pug4j.util.ArgumentSplitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CallNode
extends AttrsNode {
    protected List<String> arguments = new ArrayList<String>();
    boolean call = false;
    private boolean dynamicMixins = false;

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        boolean dynamic;
        this.dynamicMixins = dynamic = this.getName().charAt(0) == '#';
        String newname = dynamic ? this.getName().substring(2, this.getName().length() - 1) : '\"' + this.getName() + '\"';
        try {
            newname = (String)template.getExpressionHandler().evaluateExpression(newname, model);
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
        MixinNode mixin = dynamic ? model.getMixin(newname) : model.getMixin(this.getName());
        if (mixin == null) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), "mixin " + this.getName() + " is not defined");
        }
        try {
            mixin = (MixinNode)mixin.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        if (this.hasBlock()) {
            List<MixinBlockNode> injectionPoints = this.getInjectionPoints(mixin.getBlock());
            for (MixinBlockNode point : injectionPoints) {
                point.getNodes().add(this.block);
            }
        }
        if (this.isCall()) {
            model.pushScope();
            model.putLocal("block", this.block);
            this.writeVariables(model, mixin, template);
            this.writeAttributes(model, mixin, template);
            mixin.getBlock().execute(writer, model, template);
            model.putLocal("block", null);
            model.popScope();
        }
    }

    private List<MixinBlockNode> getInjectionPoints(Node block) {
        ArrayList<MixinBlockNode> result = new ArrayList<MixinBlockNode>();
        for (Node node : block.getNodes()) {
            if (node instanceof MixinBlockNode && !node.hasNodes()) {
                result.add((MixinBlockNode)node);
                continue;
            }
            if (node instanceof ConditionalNode) {
                for (IfConditionNode condition : ((ConditionalNode)node).getConditions()) {
                    result.addAll(this.getInjectionPoints(condition.getBlock()));
                }
                continue;
            }
            if (!node.hasBlock()) continue;
            result.addAll(this.getInjectionPoints(node.getBlock()));
        }
        return result;
    }

    private void writeVariables(PugModel model, MixinNode mixin, PugTemplate template) {
        List<String> names = mixin.getArguments();
        List<String> values = this.arguments;
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.size(); ++i) {
            String key = names.get(i);
            String valueExpression = mixin.getDefaultValues().get(key);
            Object value = null;
            if (i < values.size()) {
                valueExpression = values.get(i);
            }
            if (valueExpression != null) {
                try {
                    value = template.getExpressionHandler().evaluateExpression(valueExpression, model);
                }
                catch (Throwable e) {
                    throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
                }
            }
            if (key == null) continue;
            model.putLocal(key, value);
        }
        if (mixin.getRest() != null) {
            ArrayList<String> restArguments = new ArrayList<String>();
            for (int i = names.size(); i < this.arguments.size(); ++i) {
                Object value = null;
                if (i < values.size()) {
                    value = values.get(i);
                }
                if (value != null) {
                    try {
                        value = template.getExpressionHandler().evaluateExpression(values.get(i), model);
                    }
                    catch (Throwable e) {
                        throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
                    }
                }
                restArguments.add((String)value);
            }
            model.putLocal(mixin.getRest(), restArguments);
        }
    }

    private void writeAttributes(PugModel model, MixinNode mixin, PugTemplate template) {
        LinkedList<Attr> newAttributes = new LinkedList<Attr>(this.attributes);
        if (!this.attributeBlocks.isEmpty()) {
            for (String attributeBlock : this.attributeBlocks) {
                Object o = null;
                try {
                    o = template.getExpressionHandler().evaluateExpression(attributeBlock, model);
                }
                catch (ExpressionException e) {
                    throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
                }
                if (!(o instanceof Map)) continue;
                ((Map)o).entrySet().stream().map(entry -> new Attr((String)entry.getKey(), entry.getValue(), false)).forEachOrdered(newAttributes::add);
            }
        }
        if (!newAttributes.isEmpty()) {
            Map<String, String> attrs = this.attrs(model, template, newAttributes);
            model.putLocal("attributes", attrs);
        } else {
            model.putLocal("attributes", new LinkedHashMap());
        }
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setArguments(String arguments) {
        this.arguments.clear();
        this.arguments = ArgumentSplitter.split(arguments);
    }

    public boolean isCall() {
        return this.call;
    }

    public void setCall(boolean call) {
        this.call = call;
    }
}

