/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.spring.template;

import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SpringTemplateLoader
implements TemplateLoader,
ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private String encoding = "UTF-8";
    private String suffix = ".pug";
    private String templateLoaderPath = "";
    private String basePath = "";

    public long getLastModified(String name) {
        Resource resource = this.getResource(name);
        try {
            return resource.lastModified();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public Reader getReader(String name) throws IOException {
        Resource resource = this.getResource(name);
        return new InputStreamReader(resource.getInputStream(), this.encoding);
    }

    public String getExtension() {
        return this.suffix.substring(1, this.suffix.length());
    }

    private Resource getResource(String name) {
        String resourceName = this.getResourceName(name);
        if (this.hasNoExtension(resourceName)) {
            resourceName = resourceName + this.suffix;
        }
        return this.resourceLoader.getResource(resourceName);
    }

    private String getResourceName(String name) {
        name = FilenameUtils.separatorsToUnix((String)name);
        if (!StringUtils.isBlank((CharSequence)this.templateLoaderPath)) {
            if (name.startsWith("/")) {
                return FilenameUtils.normalize((String)(this.templateLoaderPath + this.basePath + name.substring(1)), (boolean)true);
            }
            return FilenameUtils.normalize((String)(this.templateLoaderPath + name), (boolean)true);
        }
        return name;
    }

    private boolean hasNoExtension(String filename) {
        return "".equals(FilenameUtils.getExtension((String)filename));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getBase() {
        return this.basePath;
    }

    public void setBase(String basePath) {
        if ((basePath = FilenameUtils.separatorsToUnix((String)basePath)) != null && !basePath.endsWith("/") && !basePath.equals("")) {
            basePath = basePath + "/";
        }
        this.basePath = basePath;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        if ((templateLoaderPath = FilenameUtils.separatorsToUnix((String)templateLoaderPath)) != null && !templateLoaderPath.endsWith("/") && !templateLoaderPath.equals("")) {
            templateLoaderPath = templateLoaderPath + "/";
        }
        this.templateLoaderPath = templateLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

