/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.spring.view;

import de.neuland.pug4j.PugConfiguration;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.exceptions.PugException;
import de.neuland.pug4j.template.PugTemplate;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class PugView
extends AbstractTemplateView {
    private String encoding;
    private PugConfiguration configuration;
    private boolean renderExceptions = false;
    private String contentType;

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doRender(model, response);
    }

    private void doRender(Map<String, Object> model, HttpServletResponse response) throws IOException {
        this.logger.trace((Object)("Rendering Pug template [" + this.getUrl() + "] in PugView '" + this.getBeanName() + "'"));
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        PrintWriter responseWriter = response.getWriter();
        if (this.renderExceptions) {
            StringWriter writer = new StringWriter();
            try {
                this.configuration.renderTemplate(this.getTemplate(), model, (Writer)writer);
                responseWriter.write(((Object)writer).toString());
            }
            catch (PugException e) {
                String htmlString = e.toHtmlString(((Object)writer).toString());
                responseWriter.write(htmlString);
                this.logger.error((Object)("failed to render template [" + this.getUrl() + "]"), (Throwable)e);
            }
            catch (IOException e) {
                responseWriter.write("<pre>could not find template: " + this.getUrl() + "\n");
                e.printStackTrace(responseWriter);
                responseWriter.write("</pre>");
                this.logger.error((Object)"could not find template", (Throwable)e);
            }
        } else {
            try {
                this.configuration.renderTemplate(this.getTemplate(), model, (Writer)responseWriter);
            }
            catch (Throwable e) {
                this.logger.error((Object)("failed to render template [" + this.getUrl() + "]\n"), e);
            }
        }
    }

    protected PugTemplate getTemplate() throws IOException, PugException {
        return this.configuration.getTemplate(this.getUrl());
    }

    public boolean checkResource(Locale locale) throws Exception {
        return this.configuration.templateExists(this.getUrl());
    }

    protected void processTemplate(PugTemplate template, Map<String, Object> model, HttpServletResponse response) throws IOException {
        try {
            this.configuration.renderTemplate(template, model, (Writer)response.getWriter());
        }
        catch (PugCompilerException e) {
            e.printStackTrace();
        }
    }

    public PugConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PugConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setRenderExceptions(boolean renderExceptions) {
        this.renderExceptions = renderExceptions;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

