/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config;

import de.novanic.eventservice.client.config.ConfigurationException;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.service.connection.id.ConnectionIdGenerator;
import de.novanic.eventservice.service.connection.strategy.connector.ConnectionStrategyServerConnector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationDependentFactory {
    private static EventServiceConfiguration myConfiguration;
    private ConnectionIdGenerator myConnectionIdGenerator;
    private ConnectionStrategyServerConnector myConnectionStrategyServerConnector;

    private ConfigurationDependentFactory() {
    }

    public static ConfigurationDependentFactory getInstance(EventServiceConfiguration aConfiguration) {
        if (aConfiguration == null) {
            throw new ConfigurationException(ConfigurationDependentFactory.class.getName() + " was initialized without a configuration!");
        }
        if (myConfiguration == null) {
            myConfiguration = aConfiguration;
        }
        return ConfigurationDependentFactoryHolder.INSTANCE;
    }

    public static ConfigurationDependentFactory getInstance() {
        if (myConfiguration == null) {
            throw new ConfigurationException(ConfigurationDependentFactory.class.getName() + " has to be initialized with a configuration before!");
        }
        return ConfigurationDependentFactoryHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionIdGenerator getConnectionIdGenerator() {
        if (this.myConnectionIdGenerator == null) {
            ConfigurationDependentFactory configurationDependentFactory = this;
            synchronized (configurationDependentFactory) {
                if (this.myConnectionIdGenerator == null) {
                    try {
                        this.myConnectionIdGenerator = (ConnectionIdGenerator)ConfigurationDependentFactory.createObject(myConfiguration.getConnectionIdGeneratorClassName());
                    }
                    catch (ClassCastException e) {
                        throw new ConfigurationException(myConfiguration.getConnectionIdGeneratorClassName() + " should have another type!", (Throwable)e);
                    }
                }
            }
        }
        return this.myConnectionIdGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStrategyServerConnector getConnectionStrategyServerConnector() {
        if (this.myConnectionStrategyServerConnector == null) {
            ConfigurationDependentFactory configurationDependentFactory = this;
            synchronized (configurationDependentFactory) {
                if (this.myConnectionStrategyServerConnector == null) {
                    try {
                        this.myConnectionStrategyServerConnector = (ConnectionStrategyServerConnector)ConfigurationDependentFactory.createObject(myConfiguration.getConnectionStrategyServerConnectorClassName());
                    }
                    catch (ClassCastException e) {
                        throw new ConfigurationException(myConfiguration.getConnectionStrategyServerConnectorClassName() + " should have another type!", (Throwable)e);
                    }
                }
            }
        }
        return this.myConnectionStrategyServerConnector;
    }

    private static <T> T createObject(String aClassName) {
        if (aClassName == null) {
            return null;
        }
        try {
            Class<?> theConnectionIdGeneratorClass = Class.forName(aClassName);
            Constructor<?> theDefaultConstructor = null;
            block9: for (Constructor<?> theConstructor : theConnectionIdGeneratorClass.getDeclaredConstructors()) {
                Class<?>[] theParameterTypes = theConstructor.getParameterTypes();
                switch (theParameterTypes.length) {
                    case 0: {
                        theDefaultConstructor = theConstructor;
                        continue block9;
                    }
                    case 1: {
                        if (!theParameterTypes[0].equals(EventServiceConfiguration.class)) continue block9;
                        return (T)theConstructor.newInstance(myConfiguration);
                    }
                }
            }
            if (theDefaultConstructor == null) {
                throw new ConfigurationException("The class \"" + theConnectionIdGeneratorClass + "\" has no default constructor and no constructor which requires a single configuration! At least one of both is needed!");
            }
            return theDefaultConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(aClassName + " couldn't be instantiated!", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(aClassName + " couldn't be instantiated!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(aClassName + " couldn't be instantiated!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(aClassName + " couldn't be instantiated!", (Throwable)e);
        }
    }

    public static EventServiceConfiguration getConfiguration() {
        return myConfiguration;
    }

    public static void reset() {
        myConfiguration = null;
        ConfigurationDependentFactoryHolder.INSTANCE.myConnectionIdGenerator = null;
        ConfigurationDependentFactoryHolder.INSTANCE.myConnectionStrategyServerConnector = null;
    }

    private static class ConfigurationDependentFactoryHolder {
        private static ConfigurationDependentFactory INSTANCE = new ConfigurationDependentFactory();

        private ConfigurationDependentFactoryHolder() {
        }
    }
}

