/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config;

import de.novanic.eventservice.client.config.ConfigurationException;
import de.novanic.eventservice.config.ConfigParameter;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.config.level.ConfigLevel;
import de.novanic.eventservice.config.level.ConfigLevelFactory;
import de.novanic.eventservice.config.loader.ConfigurationLoader;
import de.novanic.eventservice.config.loader.DefaultConfigurationLoader;
import de.novanic.eventservice.config.loader.PropertyConfigurationLoader;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventServiceConfigurationFactory {
    private final Map<ConfigLevel, Queue<ConfigurationLoader>> myConfigurationLoaders = new TreeMap<ConfigLevel, Queue<ConfigurationLoader>>();

    private EventServiceConfigurationFactory() {
        this.initConfigurationLoaders();
    }

    public static EventServiceConfigurationFactory getInstance() {
        return EventServiceConfigurationFactoryHolder.INSTANCE;
    }

    public EventServiceConfiguration loadEventServiceConfiguration(String aPropertyName) {
        this.replaceConfigurationLoader(ConfigLevelFactory.DEFAULT, new PropertyConfigurationLoader(aPropertyName));
        this.initConfigurationLoaders();
        return this.loadEventServiceConfiguration();
    }

    public EventServiceConfiguration loadEventServiceConfiguration() {
        for (Queue<ConfigurationLoader> theConfigLoaders : this.myConfigurationLoaders.values()) {
            for (ConfigurationLoader theConfigLoader : theConfigLoaders) {
                if (!theConfigLoader.isAvailable()) continue;
                return this.enrich(theConfigLoader.load());
            }
        }
        throw new ConfigurationException("No configuration is available!");
    }

    public void addCustomConfigurationLoader(ConfigurationLoader aConfigurationLoader) {
        this.addConfigurationLoader(ConfigLevelFactory.LOWEST, aConfigurationLoader);
    }

    public void addConfigurationLoader(ConfigLevel aLevel, ConfigurationLoader aConfigurationLoader) {
        Queue<ConfigurationLoader> theConfigLoaders = this.myConfigurationLoaders.get(aLevel);
        if (theConfigLoaders == null) {
            theConfigLoaders = new ConcurrentLinkedQueue<ConfigurationLoader>();
            this.myConfigurationLoaders.put(aLevel, theConfigLoaders);
        }
        theConfigLoaders.add(aConfigurationLoader);
    }

    public void removeConfigurationLoader(ConfigurationLoader aConfigurationLoader) {
        for (Queue<ConfigurationLoader> theConfigLoaders : this.myConfigurationLoaders.values()) {
            theConfigLoaders.remove(aConfigurationLoader);
        }
    }

    public void replaceConfigurationLoader(ConfigLevel aLevel, ConfigurationLoader aConfigurationLoader) {
        this.removeConfigurationLoader(aConfigurationLoader);
        this.addConfigurationLoader(aLevel, aConfigurationLoader);
    }

    private void initConfigurationLoaders() {
        this.replaceConfigurationLoader(ConfigLevelFactory.DEFAULT, new PropertyConfigurationLoader());
        this.replaceConfigurationLoader(ConfigLevelFactory.HIGHEST, new DefaultConfigurationLoader());
    }

    private EventServiceConfiguration enrich(EventServiceConfiguration aConfiguration) {
        EventServiceConfiguration theDefaultConfiguration = new DefaultConfigurationLoader().load();
        Map<ConfigParameter, Object> theDefaultConfigMap = theDefaultConfiguration.getConfigMap();
        for (Map.Entry<ConfigParameter, Object> theConfigEntry : aConfiguration.getConfigMap().entrySet()) {
            Object theValue = theConfigEntry.getValue();
            if (theValue != null) continue;
            theConfigEntry.setValue(theDefaultConfigMap.get((Object)theConfigEntry.getKey()));
        }
        return aConfiguration;
    }

    private static class EventServiceConfigurationFactoryHolder {
        private static EventServiceConfigurationFactory INSTANCE = new EventServiceConfigurationFactory();

        private EventServiceConfigurationFactoryHolder() {
        }
    }
}

