/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config;

import de.novanic.eventservice.config.ConfigParameter;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.util.PlatformUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteEventServiceConfiguration
implements EventServiceConfiguration {
    private final String myConfigDescription;
    private Map<ConfigParameter, Object> myConfigMap;

    public RemoteEventServiceConfiguration(String aConfigDescription, Integer aMinWaitingTime, Integer aMaxWaitingTime, Integer aTimeoutTime, Integer aReconnectAttemptCount, String aConnectionIdGeneratorClassName, String aConnectionStrategyClientClassName, String aConnectionStrategyServerClassName, String aConnectionStrategyEncoding, Integer aMaxEvents) {
        this.myConfigDescription = aConfigDescription;
        this.myConfigMap = new HashMap<ConfigParameter, Object>();
        this.myConfigMap.put(ConfigParameter.MIN_WAITING_TIME_TAG, aMinWaitingTime);
        this.myConfigMap.put(ConfigParameter.MAX_WAITING_TIME_TAG, aMaxWaitingTime);
        this.myConfigMap.put(ConfigParameter.TIMEOUT_TIME_TAG, aTimeoutTime);
        this.myConfigMap.put(ConfigParameter.RECONNECT_ATTEMPT_COUNT_TAG, aReconnectAttemptCount);
        this.myConfigMap.put(ConfigParameter.CONNECTION_ID_GENERATOR, aConnectionIdGeneratorClassName);
        this.myConfigMap.put(ConfigParameter.CONNECTION_STRATEGY_CLIENT_CONNECTOR, aConnectionStrategyClientClassName);
        this.myConfigMap.put(ConfigParameter.CONNECTION_STRATEGY_SERVER_CONNECTOR, aConnectionStrategyServerClassName);
        this.myConfigMap.put(ConfigParameter.CONNECTION_STRATEGY_ENCODING, aConnectionStrategyEncoding);
        this.myConfigMap.put(ConfigParameter.MAX_EVENTS, aMaxEvents);
    }

    @Override
    public String getConfigDescription() {
        return this.myConfigDescription;
    }

    @Override
    public Integer getMinWaitingTime() {
        return (Integer)this.myConfigMap.get((Object)ConfigParameter.MIN_WAITING_TIME_TAG);
    }

    @Override
    public Integer getMaxWaitingTime() {
        return (Integer)this.myConfigMap.get((Object)ConfigParameter.MAX_WAITING_TIME_TAG);
    }

    @Override
    public Integer getTimeoutTime() {
        return (Integer)this.myConfigMap.get((Object)ConfigParameter.TIMEOUT_TIME_TAG);
    }

    @Override
    public Integer getReconnectAttemptCount() {
        return (Integer)this.myConfigMap.get((Object)ConfigParameter.RECONNECT_ATTEMPT_COUNT_TAG);
    }

    @Override
    public String getConnectionIdGeneratorClassName() {
        return (String)this.myConfigMap.get((Object)ConfigParameter.CONNECTION_ID_GENERATOR);
    }

    @Override
    public String getConnectionStrategyClientConnectorClassName() {
        return (String)this.myConfigMap.get((Object)ConfigParameter.CONNECTION_STRATEGY_CLIENT_CONNECTOR);
    }

    @Override
    public String getConnectionStrategyServerConnectorClassName() {
        return (String)this.myConfigMap.get((Object)ConfigParameter.CONNECTION_STRATEGY_SERVER_CONNECTOR);
    }

    @Override
    public String getConnectionStrategyEncoding() {
        return (String)this.myConfigMap.get((Object)ConfigParameter.CONNECTION_STRATEGY_ENCODING);
    }

    @Override
    public Integer getMaxEvents() {
        return (Integer)this.myConfigMap.get((Object)ConfigParameter.MAX_EVENTS);
    }

    @Override
    public Map<ConfigParameter, Object> getConfigMap() {
        return this.myConfigMap;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass()) {
            return false;
        }
        EventServiceConfiguration theConfiguration = (EventServiceConfiguration)anObject;
        return this.getConfigMap().equals(theConfiguration.getConfigMap()) && this.myConfigDescription.equals(theConfiguration.getConfigDescription());
    }

    public int hashCode() {
        int theResult = this.getConfigMap().hashCode();
        theResult = 31 * theResult + this.myConfigDescription.hashCode();
        return theResult;
    }

    public String toString() {
        String UNDEFINED = "<undefined>";
        Integer theMinWaitingTime = this.getMinWaitingTime();
        Integer theMaxWaitingTime = this.getMaxWaitingTime();
        Integer theTimeoutTime = this.getTimeoutTime();
        StringBuilder theConfigStringBuilder = new StringBuilder(120);
        theConfigStringBuilder.append("EventServiceConfiguration (");
        theConfigStringBuilder.append(this.getConfigDescription());
        theConfigStringBuilder.append(')');
        theConfigStringBuilder.append(PlatformUtil.getNewLine());
        theConfigStringBuilder.append("  Min.: ");
        if (theMinWaitingTime != null) {
            theConfigStringBuilder.append(theMinWaitingTime);
        } else {
            theConfigStringBuilder.append("<undefined>");
        }
        theConfigStringBuilder.append("ms; Max.: ");
        if (theMaxWaitingTime != null) {
            theConfigStringBuilder.append(theMaxWaitingTime);
        } else {
            theConfigStringBuilder.append("<undefined>");
        }
        theConfigStringBuilder.append("ms; Timeout: ");
        if (theTimeoutTime != null) {
            theConfigStringBuilder.append(theTimeoutTime);
        } else {
            theConfigStringBuilder.append("<undefined>");
        }
        theConfigStringBuilder.append("ms");
        return theConfigStringBuilder.toString();
    }
}

