/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config.level;

import de.novanic.eventservice.config.level.ConfigLevel;

public final class ConfigLevelFactory {
    public static final ConfigLevel LOWEST = ConfigLevelFactory.createConfigLevel(1);
    public static final ConfigLevel LOW = ConfigLevelFactory.createConfigLevel(2500);
    public static final ConfigLevel DEFAULT = ConfigLevelFactory.createConfigLevel(5000);
    public static final ConfigLevel HIGH = ConfigLevelFactory.createConfigLevel(7500);
    public static final ConfigLevel HIGHEST = ConfigLevelFactory.createConfigLevel(10000);

    private ConfigLevelFactory() {
    }

    public static ConfigLevel createConfigLevel(int aLevelIdent) {
        return new DefaultConfigLevel(aLevelIdent);
    }

    private static class DefaultConfigLevel
    implements ConfigLevel {
        private final int myLevel;

        private DefaultConfigLevel(int aLevel) {
            this.myLevel = aLevel;
        }

        public int getLevel() {
            return this.myLevel;
        }

        public int compareTo(ConfigLevel aConfigLevel) {
            int theOtherLevel = aConfigLevel.getLevel();
            if (this.myLevel > theOtherLevel) {
                return 1;
            }
            if (this.myLevel < theOtherLevel) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject == null || this.getClass() != anObject.getClass()) {
                return false;
            }
            DefaultConfigLevel theOtherConfigLevel = (DefaultConfigLevel)anObject;
            return this.myLevel == theOtherConfigLevel.myLevel;
        }

        public int hashCode() {
            return this.myLevel;
        }

        public String toString() {
            return "DefaultConfigLevel: " + this.myLevel;
        }
    }
}

