/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config.loader;

import de.novanic.eventservice.client.config.ConfigurationException;
import de.novanic.eventservice.config.ConfigParameter;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.config.RemoteEventServiceConfiguration;
import de.novanic.eventservice.config.loader.ConfigurationLoader;
import de.novanic.eventservice.logger.ServerLogger;
import de.novanic.eventservice.logger.ServerLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;

public class PropertyConfigurationLoader
implements ConfigurationLoader {
    private static final ServerLogger LOG = ServerLoggerFactory.getServerLogger(PropertyConfigurationLoader.class.getName());
    private static final String DEFAULT_PROPERTY_NAME = "eventservice.properties";
    private final String myPropertyName;

    public PropertyConfigurationLoader() {
        this(null);
    }

    public PropertyConfigurationLoader(String aPropertyName) {
        this.myPropertyName = aPropertyName != null ? aPropertyName : DEFAULT_PROPERTY_NAME;
    }

    public boolean isAvailable() {
        return this.getPropertiesStream() != null;
    }

    public EventServiceConfiguration load() {
        InputStream thePropertiesInputStream = this.getPropertiesStream();
        if (thePropertiesInputStream != null) {
            try {
                Properties theProperties = new Properties();
                theProperties.load(thePropertiesInputStream);
                EventServiceConfiguration eventServiceConfiguration = this.load(theProperties);
                return eventServiceConfiguration;
            }
            catch (IOException e) {
                throw new ConfigurationException("Error on loading \"" + this.myPropertyName + "\"!", (Throwable)e);
            }
            finally {
                try {
                    thePropertiesInputStream.close();
                }
                catch (IOException e) {
                    LOG.error("Error on closing stream of \"" + this.myPropertyName + "\"!", e);
                }
            }
        }
        return null;
    }

    private InputStream getPropertiesStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.myPropertyName);
    }

    private EventServiceConfiguration load(Properties aProperties) {
        Integer theMaxWaitingTime = this.getIntValue(this.getPropertyValue(aProperties, ConfigParameter.FQ_MAX_WAITING_TIME_TAG, ConfigParameter.MAX_WAITING_TIME_TAG));
        Integer theMinWaitingTime = this.getIntValue(this.getPropertyValue(aProperties, ConfigParameter.FQ_MIN_WAITING_TIME_TAG, ConfigParameter.MIN_WAITING_TIME_TAG));
        Integer theTimeoutTime = this.getIntValue(this.getPropertyValue(aProperties, ConfigParameter.FQ_TIMEOUT_TIME_TAG, ConfigParameter.TIMEOUT_TIME_TAG));
        Integer theReconnectAttemptCount = this.getIntValue(this.getPropertyValue(aProperties, ConfigParameter.FQ_RECONNECT_ATTEMPT_COUNT_TAG, ConfigParameter.RECONNECT_ATTEMPT_COUNT_TAG));
        String theConnectionIdGenerator = this.getPropertyValue(aProperties, ConfigParameter.FQ_CONNECTION_ID_GENERATOR, ConfigParameter.CONNECTION_ID_GENERATOR);
        String theConnectionStrategyClientConnector = this.getPropertyValue(aProperties, ConfigParameter.FQ_CONNECTION_STRATEGY_CLIENT_CONNECTOR, ConfigParameter.CONNECTION_STRATEGY_CLIENT_CONNECTOR);
        String theConnectionStrategyServerConnector = this.getPropertyValue(aProperties, ConfigParameter.FQ_CONNECTION_STRATEGY_SERVER_CONNECTOR, ConfigParameter.CONNECTION_STRATEGY_SERVER_CONNECTOR);
        String theConnectionStrategyEncoding = this.getPropertyValue(aProperties, ConfigParameter.FQ_CONNECTION_STRATEGY_ENCODING, ConfigParameter.CONNECTION_STRATEGY_ENCODING);
        Integer theMaxEvents = this.getIntValue(this.getPropertyValue(aProperties, ConfigParameter.FQ_MAX_EVENTS, ConfigParameter.MAX_EVENTS));
        return new RemoteEventServiceConfiguration(this.getConfigDescription(), theMinWaitingTime, theMaxWaitingTime, theTimeoutTime, theReconnectAttemptCount, theConnectionIdGenerator, theConnectionStrategyClientConnector, theConnectionStrategyServerConnector, theConnectionStrategyEncoding, theMaxEvents);
    }

    private Integer getIntValue(String aString) {
        if (aString != null) {
            Scanner theScanner = new Scanner(aString);
            if (theScanner.hasNextInt()) {
                return theScanner.nextInt();
            }
            throw new ConfigurationException("Error on processing configuration \"" + this.myPropertyName + "\"! " + "The value \"" + aString + "\" couldn't parsed to an integer!");
        }
        return null;
    }

    private String getConfigDescription() {
        StringBuilder theConfigDescriptionBuffer = new StringBuilder(15 + this.myPropertyName.length());
        theConfigDescriptionBuffer.append("Properties \"");
        theConfigDescriptionBuffer.append(this.myPropertyName);
        theConfigDescriptionBuffer.append('\"');
        return theConfigDescriptionBuffer.toString();
    }

    private String getPropertyValue(Properties aProperties, ConfigParameter ... aConfigParameters) {
        for (ConfigParameter theConfigParameter : aConfigParameters) {
            String theValue = aProperties.getProperty(theConfigParameter.declaration());
            if (theValue == null) continue;
            return theValue;
        }
        return null;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass()) {
            return false;
        }
        PropertyConfigurationLoader theOtherLoader = (PropertyConfigurationLoader)anObject;
        return this.myPropertyName.equals(theOtherLoader.myPropertyName);
    }

    public int hashCode() {
        return this.myPropertyName.hashCode();
    }
}

