/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.config.loader;

import de.novanic.eventservice.client.config.ConfigurationException;
import de.novanic.eventservice.config.ConfigParameter;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.config.RemoteEventServiceConfiguration;
import de.novanic.eventservice.config.loader.ConfigurationLoader;
import de.novanic.eventservice.util.ServiceUtilException;
import de.novanic.eventservice.util.StringUtil;
import javax.servlet.ServletConfig;

public class WebDescriptorConfigurationLoader
implements ConfigurationLoader {
    private final ServletConfig myServletConfig;

    public WebDescriptorConfigurationLoader(ServletConfig aServletConfig) {
        this.myServletConfig = aServletConfig;
    }

    public boolean isAvailable() {
        if (this.myServletConfig != null) {
            for (ConfigParameter theConfigParameter : ConfigParameter.values()) {
                String theParameterValue = this.myServletConfig.getInitParameter(theConfigParameter.declaration());
                if (theParameterValue == null) continue;
                return true;
            }
        }
        return false;
    }

    public EventServiceConfiguration load() {
        if (this.isAvailable()) {
            return new RemoteEventServiceConfiguration("Web-Descriptor-Configuration", this.readIntParameter(ConfigParameter.MIN_WAITING_TIME_TAG.declaration(), ConfigParameter.FQ_MIN_WAITING_TIME_TAG.declaration()), this.readIntParameter(ConfigParameter.MAX_WAITING_TIME_TAG.declaration(), ConfigParameter.FQ_MAX_WAITING_TIME_TAG.declaration()), this.readIntParameter(ConfigParameter.TIMEOUT_TIME_TAG.declaration(), ConfigParameter.FQ_TIMEOUT_TIME_TAG.declaration()), this.readIntParameter(ConfigParameter.RECONNECT_ATTEMPT_COUNT_TAG.declaration(), ConfigParameter.FQ_RECONNECT_ATTEMPT_COUNT_TAG.declaration()), this.readParameter(ConfigParameter.CONNECTION_ID_GENERATOR.declaration(), ConfigParameter.FQ_CONNECTION_ID_GENERATOR.declaration()), this.readParameter(ConfigParameter.CONNECTION_STRATEGY_CLIENT_CONNECTOR.declaration(), ConfigParameter.FQ_CONNECTION_STRATEGY_CLIENT_CONNECTOR.declaration()), this.readParameter(ConfigParameter.CONNECTION_STRATEGY_SERVER_CONNECTOR.declaration(), ConfigParameter.FQ_CONNECTION_STRATEGY_SERVER_CONNECTOR.declaration()), this.readParameter(ConfigParameter.CONNECTION_STRATEGY_ENCODING.declaration(), ConfigParameter.FQ_CONNECTION_STRATEGY_ENCODING.declaration()), this.readIntParameter(ConfigParameter.MAX_EVENTS.declaration(), ConfigParameter.FQ_MAX_EVENTS.declaration()));
        }
        return null;
    }

    private boolean isAvailable(String aParameterValue) {
        return aParameterValue != null && aParameterValue.trim().length() > 0;
    }

    private Integer readIntParameter(String aParameterName, String aParameterNameFQ) {
        String theParameterValue = this.readParameter(aParameterName, aParameterNameFQ);
        if (theParameterValue != null) {
            try {
                return StringUtil.readInteger(theParameterValue);
            }
            catch (ServiceUtilException e) {
                throw new ConfigurationException("The value of the parameter \"" + aParameterName + "\" was expected to be numeric, but was \"" + theParameterValue + "\"!", (Throwable)e);
            }
        }
        return null;
    }

    private String readParameter(String aParameterName, String aParameterNameFQ) {
        if (this.isAvailable(this.myServletConfig.getInitParameter(aParameterNameFQ))) {
            return this.myServletConfig.getInitParameter(aParameterNameFQ);
        }
        return this.myServletConfig.getInitParameter(aParameterName);
    }
}

