/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.event.listener.unlisten;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.filter.EventFilter;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEvent;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEventListener;
import de.novanic.eventservice.service.registry.domain.ListenDomainAccessor;
import java.util.Set;

public class UnlistenEventFilter
implements EventFilter {
    private final String myUserId;
    private final ListenDomainAccessor myListenDomainAccessor;
    private final UnlistenEventListener.Scope myUnlistenScope;

    public UnlistenEventFilter(ListenDomainAccessor aListenDomainAccessor, String aUserId, UnlistenEventListener.Scope anUnlistenScope) {
        this.myUserId = aUserId;
        this.myListenDomainAccessor = aListenDomainAccessor;
        this.myUnlistenScope = anUnlistenScope;
    }

    public boolean match(Event anEvent) {
        if (anEvent instanceof UnlistenEvent) {
            Set theUnlistenedDomains;
            UnlistenEvent theUnlistenEvent = (UnlistenEvent)anEvent;
            if ((UnlistenEventListener.Scope.UNLISTEN == this.myUnlistenScope || UnlistenEventListener.Scope.TIMEOUT == this.myUnlistenScope && theUnlistenEvent.isTimeout()) && (theUnlistenedDomains = theUnlistenEvent.getDomains()) != null && !theUnlistenedDomains.isEmpty()) {
                Set<Domain> theRegisteredListenDomains = this.myListenDomainAccessor.getListenDomains(this.myUserId);
                for (Domain theUnlistenedDomain : theUnlistenedDomains) {
                    if (!theRegisteredListenDomains.contains(theUnlistenedDomain)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

