/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.logger;

import de.novanic.eventservice.logger.ServerLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultServerLogger
implements ServerLogger {
    private static final String SERVER_LOG_PREFIX = "Server: ";
    private final Logger LOG;

    protected DefaultServerLogger(String aLoggerName) {
        this.LOG = Logger.getLogger(aLoggerName);
    }

    public void debug(String aMessage) {
        this.log(Level.FINEST, aMessage);
    }

    public void info(String aMessage) {
        this.log(Level.INFO, aMessage);
    }

    public void error(String aMessage) {
        this.log(Level.SEVERE, aMessage);
    }

    public void error(String aMessage, Throwable aThrowable) {
        if (this.LOG.isLoggable(Level.SEVERE)) {
            this.LOG.log(Level.SEVERE, SERVER_LOG_PREFIX + aMessage, aThrowable);
        }
    }

    public void log(Level aLevel, String aMessage) {
        if (this.LOG.isLoggable(aLevel)) {
            this.LOG.log(aLevel, SERVER_LOG_PREFIX + aMessage);
        }
    }
}

