/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.filter.EventFilter;
import de.novanic.eventservice.service.EventExecutorService;
import de.novanic.eventservice.service.exception.NoSessionAvailableException;
import de.novanic.eventservice.service.registry.EventRegistry;
import de.novanic.eventservice.service.registry.EventRegistryFactory;

public class DefaultEventExecutorService
implements EventExecutorService {
    private static EventRegistry myEventRegistry;
    private final String myClientId;

    DefaultEventExecutorService(String aClientId) {
        this.myClientId = aClientId;
    }

    public boolean isUserRegistered() {
        return myEventRegistry.isUserRegistered(this.getClientId());
    }

    public boolean isUserRegistered(Domain aDomain) {
        return myEventRegistry.isUserRegistered(aDomain, this.getClientId());
    }

    public void addEvent(Domain aDomain, Event anEvent) {
        myEventRegistry.addEvent(aDomain, anEvent);
    }

    public void addEventUserSpecific(Event anEvent) {
        myEventRegistry.addEventUserSpecific(this.getClientId(), anEvent);
    }

    public void setEventFilter(Domain aDomain, EventFilter anEventFilter) {
        myEventRegistry.setEventFilter(aDomain, this.getClientId(), anEventFilter);
    }

    public EventFilter getEventFilter(Domain aDomain) {
        return myEventRegistry.getEventFilter(aDomain, this.getClientId());
    }

    public void removeEventFilter(Domain aDomain) {
        myEventRegistry.removeEventFilter(aDomain, this.getClientId());
    }

    private String getClientId() {
        if (this.myClientId == null) {
            throw new NoSessionAvailableException();
        }
        return this.myClientId;
    }

    private static void init() {
        EventRegistryFactory theEventRegistryFactory = EventRegistryFactory.getInstance();
        myEventRegistry = theEventRegistryFactory.getEventRegistry();
    }

    static {
        DefaultEventExecutorService.init();
    }
}

