/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service;

import de.novanic.eventservice.config.ConfigurationDependentFactory;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.service.DefaultEventExecutorService;
import de.novanic.eventservice.service.EventExecutorService;
import de.novanic.eventservice.service.connection.id.ConnectionIdGenerator;
import de.novanic.eventservice.service.registry.EventRegistryFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class EventExecutorServiceFactory {
    private EventExecutorServiceFactory() {
    }

    public static EventExecutorServiceFactory getInstance() {
        return EventExecutorServiceFactoryHolder.INSTANCE;
    }

    public EventExecutorService getEventExecutorService(HttpSession aHttpSession) {
        String theClientId = null;
        if (aHttpSession != null) {
            theClientId = aHttpSession.getId();
        }
        return this.getEventExecutorService(theClientId);
    }

    public EventExecutorService getEventExecutorService(HttpServletRequest aRequest) {
        String theConnectionId = null;
        if (aRequest != null) {
            EventServiceConfiguration theConfiguration = EventRegistryFactory.getInstance().getEventRegistry().getConfiguration();
            ConnectionIdGenerator theConnectionIdGenerator = ConfigurationDependentFactory.getInstance(theConfiguration).getConnectionIdGenerator();
            theConnectionId = theConnectionIdGenerator.getConnectionId(aRequest);
        }
        return this.getEventExecutorService(theConnectionId);
    }

    public EventExecutorService getEventExecutorService(String aClientId) {
        return new DefaultEventExecutorService(aClientId);
    }

    private static class EventExecutorServiceFactoryHolder {
        private static final EventExecutorServiceFactory INSTANCE = new EventExecutorServiceFactory();

        private EventExecutorServiceFactoryHolder() {
        }
    }
}

