/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import de.novanic.eventservice.client.config.EventServiceConfigurationTransferable;
import de.novanic.eventservice.client.config.RemoteEventServiceConfigurationTransferable;
import de.novanic.eventservice.client.event.DomainEvent;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.filter.EventFilter;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEvent;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEventListener;
import de.novanic.eventservice.client.event.service.EventService;
import de.novanic.eventservice.config.ConfigurationDependentFactory;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.config.EventServiceConfigurationFactory;
import de.novanic.eventservice.config.level.ConfigLevelFactory;
import de.novanic.eventservice.config.loader.WebDescriptorConfigurationLoader;
import de.novanic.eventservice.logger.ServerLogger;
import de.novanic.eventservice.logger.ServerLoggerFactory;
import de.novanic.eventservice.service.EventServiceException;
import de.novanic.eventservice.service.connection.id.SessionConnectionIdGenerator;
import de.novanic.eventservice.service.connection.strategy.connector.ConnectionStrategyServerConnector;
import de.novanic.eventservice.service.connection.strategy.connector.streaming.StreamingServerConnector;
import de.novanic.eventservice.service.registry.EventRegistry;
import de.novanic.eventservice.service.registry.EventRegistryFactory;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventServiceImpl
extends RemoteServiceServlet
implements EventService {
    private static final ServerLogger LOG = ServerLoggerFactory.getServerLogger(EventServiceImpl.class.getName());
    private EventRegistry myEventRegistry;
    private ConfigurationDependentFactory myConfigurationDependentFactory;

    public void init(ServletConfig aConfig) throws ServletException {
        super.init(aConfig);
        this.myEventRegistry = this.initEventRegistry(aConfig);
        EventServiceConfiguration theConfiguration = this.myEventRegistry.getConfiguration();
        this.myConfigurationDependentFactory = ConfigurationDependentFactory.getInstance(theConfiguration);
    }

    public void destroy() {
        super.destroy();
        EventRegistryFactory.getInstance().resetEventRegistry();
    }

    protected void doGet(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        ConnectionStrategyServerConnector theConnectionStrategyServerConnector = this.myConfigurationDependentFactory.getConnectionStrategyServerConnector();
        if (theConnectionStrategyServerConnector instanceof StreamingServerConnector) {
            String theClientId = this.getClientId(aRequest);
            StreamingServerConnector theStreamingServerConnector = (StreamingServerConnector)theConnectionStrategyServerConnector;
            try {
                theStreamingServerConnector = (StreamingServerConnector)theStreamingServerConnector.clone();
                theStreamingServerConnector.prepare(aResponse);
                this.listen(theStreamingServerConnector, theClientId);
            }
            catch (EventServiceException e) {
                throw new ServletException("Error on streaming events to the client\"" + theClientId + "\"!", (Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                throw new ServletException("Error on cloning \"" + StreamingServerConnector.class.getName() + "\" for client \"" + theClientId + "\"!", (Throwable)e);
            }
            finally {
                ServletOutputStream theServletOutputStream = aResponse.getOutputStream();
                theServletOutputStream.close();
            }
        }
    }

    public EventServiceConfigurationTransferable initEventService() {
        String theClientId = this.generateClientId();
        EventServiceConfiguration theConfiguration = this.myEventRegistry.getConfiguration();
        String theClientIdTransferable = SessionConnectionIdGenerator.class.getName().equals(theConfiguration.getConnectionIdGeneratorClassName()) ? null : theClientId;
        LOG.info("Client \"" + theClientId + "\" initialized.");
        return new RemoteEventServiceConfigurationTransferable(theConfiguration.getMinWaitingTime().intValue(), theConfiguration.getMaxWaitingTime().intValue(), theConfiguration.getTimeoutTime().intValue(), theConfiguration.getReconnectAttemptCount().intValue(), theClientIdTransferable, theConfiguration.getConnectionStrategyClientConnectorClassName());
    }

    public void register(Domain aDomain) {
        this.register(aDomain, null);
    }

    public void register(Domain aDomain, EventFilter anEventFilter) {
        String theClientId = this.getClientId();
        this.myEventRegistry.registerUser(aDomain, theClientId, anEventFilter);
    }

    public void register(Set<Domain> aDomains) {
        for (Domain aDomain : aDomains) {
            this.register(aDomain);
        }
    }

    public void register(Set<Domain> aDomains, EventFilter anEventFilter) {
        for (Domain aDomain : aDomains) {
            this.register(aDomain, anEventFilter);
        }
    }

    public void registerUnlistenEvent(UnlistenEventListener.Scope anUnlistenScope, UnlistenEvent anUnlistenEvent) {
        String theClientId = this.getClientId();
        this.myEventRegistry.registerUnlistenEvent(theClientId, anUnlistenScope, anUnlistenEvent);
    }

    public void registerEventFilter(Domain aDomain, EventFilter anEventFilter) {
        String theClientId = this.getClientId();
        this.myEventRegistry.setEventFilter(aDomain, theClientId, anEventFilter);
    }

    public void deregisterEventFilter(Domain aDomain) {
        String theClientId = this.getClientId();
        this.myEventRegistry.removeEventFilter(aDomain, theClientId);
    }

    public EventFilter getEventFilter(Domain aDomain) {
        String theClientId = this.getClientId();
        return this.myEventRegistry.getEventFilter(aDomain, theClientId);
    }

    public List<DomainEvent> listen() {
        String theClientId = this.getClientId();
        ConnectionStrategyServerConnector theConnectionStrategyServerConnector = this.myConfigurationDependentFactory.getConnectionStrategyServerConnector();
        LOG.debug("Listen (client id \"" + theClientId + "\").");
        return this.listen(theConnectionStrategyServerConnector, theClientId);
    }

    private List<DomainEvent> listen(ConnectionStrategyServerConnector aServerEventListener, String aClientId) {
        LOG.debug("Listen (client id \"" + aClientId + "\").");
        return this.myEventRegistry.listen(aServerEventListener, aClientId);
    }

    public void unlisten() {
        String theClientId = this.getClientId();
        LOG.debug("Unlisten (client id \"" + theClientId + "\").");
        this.myEventRegistry.unlisten(theClientId);
        LOG.debug("Unlisten finished (client id \"" + theClientId + "\").");
    }

    public void unlisten(Domain aDomain) {
        String theClientId = this.getClientId();
        LOG.debug("Unlisten (client id \"" + theClientId + "\").");
        this.myEventRegistry.unlisten(aDomain, theClientId);
        LOG.debug("Unlisten finished (client id \"" + theClientId + "\").");
    }

    public void unlisten(Set<Domain> aDomains) {
        for (Domain theDomain : aDomains) {
            this.unlisten(theDomain);
        }
    }

    public boolean isUserRegistered(Domain aDomain) {
        String theClientId = this.getClientId();
        return this.myEventRegistry.isUserRegistered(aDomain, theClientId);
    }

    public void addEvent(Domain aDomain, Event anEvent) {
        this.myEventRegistry.addEvent(aDomain, anEvent);
    }

    public void addEventUserSpecific(Event anEvent) {
        String theClientId = this.getClientId();
        this.myEventRegistry.addEventUserSpecific(theClientId, anEvent);
    }

    public Set<Domain> getActiveListenDomains() {
        String theClientId = this.getClientId();
        return this.myEventRegistry.getListenDomains(theClientId);
    }

    private EventRegistry initEventRegistry(ServletConfig aConfig) {
        WebDescriptorConfigurationLoader theWebDescriptorConfigurationLoader = new WebDescriptorConfigurationLoader(aConfig);
        EventServiceConfigurationFactory theEventServiceConfigurationFactory = EventServiceConfigurationFactory.getInstance();
        theEventServiceConfigurationFactory.addConfigurationLoader(ConfigLevelFactory.DEFAULT, theWebDescriptorConfigurationLoader);
        EventRegistryFactory theEventRegistryFactory = EventRegistryFactory.getInstance();
        EventRegistry theEventRegistry = theEventRegistryFactory.getEventRegistry();
        if (theWebDescriptorConfigurationLoader.isAvailable()) {
            theEventServiceConfigurationFactory.loadEventServiceConfiguration();
        }
        return theEventRegistry;
    }

    protected String getClientId() {
        return this.getClientId(this.getThreadLocalRequest());
    }

    protected String getClientId(HttpServletRequest aRequest) {
        return this.myConfigurationDependentFactory.getConnectionIdGenerator().getConnectionId(aRequest);
    }

    protected String generateClientId() {
        return this.myConfigurationDependentFactory.getConnectionIdGenerator().generateConnectionId(this.getThreadLocalRequest());
    }

    protected void checkPermutationStrongName() throws SecurityException {
    }
}

