/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.connection.strategy.connector;

import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.service.EventServiceException;
import de.novanic.eventservice.service.connection.strategy.connector.ConnectionStrategyServerConnector;
import de.novanic.eventservice.service.registry.user.UserInfo;
import java.io.UnsupportedEncodingException;

public abstract class ConnectionStrategyServerConnectorAdapter
implements ConnectionStrategyServerConnector {
    private EventServiceConfiguration myConfiguration;
    private static String ENCODING;

    protected ConnectionStrategyServerConnectorAdapter(EventServiceConfiguration aConfiguration) {
        this.myConfiguration = aConfiguration;
        ENCODING = this.myConfiguration.getConnectionStrategyEncoding();
    }

    protected EventServiceConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    protected void waitMinWaitingTime() throws EventServiceException {
        this.waitTime(this.myConfiguration.getMinWaitingTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitMaxWaitingTime(UserInfo aUserInfo) throws EventServiceException {
        int theMaxWaitingTime = this.myConfiguration.getMaxWaitingTime();
        if (theMaxWaitingTime <= 0) {
            return true;
        }
        if (aUserInfo.isEventsEmpty()) {
            UserInfo userInfo = aUserInfo;
            synchronized (userInfo) {
                if (aUserInfo.isEventsEmpty()) {
                    try {
                        long theStartTime = System.currentTimeMillis();
                        aUserInfo.wait(theMaxWaitingTime);
                        return System.currentTimeMillis() - theStartTime >= (long)theMaxWaitingTime;
                    }
                    catch (InterruptedException e) {
                        throw new EventServiceException("Error on waiting max. waiting time!", e);
                    }
                }
            }
        }
        return false;
    }

    private void waitTime(int aWaitingTime) throws EventServiceException {
        if (aWaitingTime > 0) {
            try {
                Thread.sleep(aWaitingTime);
            }
            catch (InterruptedException e) {
                throw new EventServiceException("Error on waiting min. waiting time!", e);
            }
        }
    }

    protected static String getEncoding() throws EventServiceException {
        if (ENCODING != null) {
            return ENCODING;
        }
        throw new EventServiceException("The encoding property wasn't initialized. It is initialized with the configuration at the time of object construction.");
    }

    protected static byte[] encode(String aString) throws EventServiceException {
        try {
            return aString.getBytes(ConnectionStrategyServerConnectorAdapter.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new EventServiceException("Error on encoding \"" + aString + "\"!", e);
        }
    }
}

