/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.connection.strategy.connector.streaming;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import de.novanic.eventservice.client.event.DomainEvent;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.logger.ServerLogger;
import de.novanic.eventservice.logger.ServerLoggerFactory;
import de.novanic.eventservice.service.EventServiceException;
import de.novanic.eventservice.service.connection.strategy.connector.ConnectionStrategyServerConnectorAdapter;
import de.novanic.eventservice.service.connection.strategy.connector.streaming.EventSerializationPolicy;
import de.novanic.eventservice.service.registry.user.UserInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingServerConnector
extends ConnectionStrategyServerConnectorAdapter
implements Cloneable {
    private static byte[] SCRIPT_TAG_PREFIX;
    private static byte[] SCRIPT_TAG_SUFFIX;
    private static byte[] CYCLE_TAG;
    private static final ServerLogger LOG;
    private HttpServletResponse myResponse;
    private OutputStream myOutputStream;
    private SerializationPolicy mySerializationPolicy;

    public StreamingServerConnector(EventServiceConfiguration aConfiguration) throws EventServiceException {
        this(aConfiguration, new EventSerializationPolicy());
        SCRIPT_TAG_PREFIX = StreamingServerConnector.encode("<script type='text/javascript'>window.parent.receiveEvent('");
        SCRIPT_TAG_SUFFIX = StreamingServerConnector.encode("');</script>");
        CYCLE_TAG = StreamingServerConnector.encode("cycle");
    }

    protected StreamingServerConnector(EventServiceConfiguration aConfiguration, SerializationPolicy aSerializationPolicy) {
        super(aConfiguration);
        this.mySerializationPolicy = aSerializationPolicy;
    }

    public void prepare(HttpServletResponse aResponse) throws EventServiceException {
        this.myResponse = aResponse;
        try {
            this.myOutputStream = aResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new EventServiceException("Error on using output stream of the response!", e);
        }
        this.myResponse.setContentType("text/html;charset=" + StreamingServerConnector.getEncoding());
        this.myResponse.setHeader("expires", "0");
        this.myResponse.setHeader("cache-control", "no-cache");
        this.myResponse.setHeader("transfer-encoding", "chunked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomainEvent> listen(UserInfo aUserInfo) throws EventServiceException {
        ArrayList<DomainEvent> theEvents = new ArrayList<DomainEvent>();
        try {
            do {
                List<DomainEvent> theCurrentEvents;
                if ((theCurrentEvents = aUserInfo.retrieveEvents(this.getConfiguration().getMaxEvents())).isEmpty()) continue;
                aUserInfo.reportUserActivity();
                theEvents.addAll(theCurrentEvents);
                for (DomainEvent theEvent : theCurrentEvents) {
                    String theSerializedEvent = this.serialize(theEvent);
                    theSerializedEvent = this.escapeSerializedData(theSerializedEvent);
                    this.printStatement(StreamingServerConnector.encode(theSerializedEvent), this.myOutputStream);
                }
                aUserInfo.reportUserActivity();
            } while (!this.waitMaxWaitingTime(aUserInfo));
            this.printStatement(CYCLE_TAG, this.myOutputStream);
        }
        catch (FlushException e) {
            LOG.debug(e.getMessage());
        }
        finally {
            try {
                this.close(this.myOutputStream);
            }
            catch (CloseException e) {
                LOG.debug(e.getMessage());
            }
        }
        return theEvents;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private String serialize(DomainEvent anEvent) throws EventServiceException {
        try {
            ServerSerializationStreamWriter theServerSerializationStreamWriter = new ServerSerializationStreamWriter(this.mySerializationPolicy);
            theServerSerializationStreamWriter.setFlags(0);
            theServerSerializationStreamWriter.prepareToWrite();
            theServerSerializationStreamWriter.serializeValue((Object)anEvent, DomainEvent.class);
            return theServerSerializationStreamWriter.toString();
        }
        catch (SerializationException e) {
            throw new EventServiceException("Error on serializing the event \"" + anEvent + "\" for domain \"" + anEvent.getDomain() + "\"!", e);
        }
    }

    private String escapeSerializedData(String aSerializedData) {
        String theEscapedData = aSerializedData;
        theEscapedData = theEscapedData.replaceAll("\\\\", "\\\\\\\\");
        theEscapedData = theEscapedData.replaceAll("\\'", "\\\\'");
        return theEscapedData;
    }

    private void printStatement(byte[] aStatement, OutputStream anOutputStream) throws EventServiceException, FlushException {
        try {
            anOutputStream.write(SCRIPT_TAG_PREFIX);
            anOutputStream.write(aStatement);
            anOutputStream.write(SCRIPT_TAG_SUFFIX);
        }
        catch (IOException e) {
            throw new EventServiceException("Error on printing statement \"" + new String(aStatement) + "\"!", e);
        }
        finally {
            this.flush(aStatement, anOutputStream);
        }
    }

    private void flush(byte[] aStatement, OutputStream anOutputStream) throws FlushException {
        try {
            anOutputStream.flush();
            this.myResponse.flushBuffer();
        }
        catch (IOException e) {
            throw new FlushException(aStatement, e);
        }
    }

    private void close(OutputStream anOutputStream) throws CloseException {
        try {
            anOutputStream.close();
        }
        catch (IOException e) {
            throw new CloseException(e);
        }
    }

    static {
        LOG = ServerLoggerFactory.getServerLogger(StreamingServerConnector.class.getName());
    }

    private static class FlushException
    extends Exception {
        private FlushException(byte[] aFlushingStatement, Throwable aThrowable) {
            super(FlushException.createMessage(aFlushingStatement), aThrowable);
        }

        private static String createMessage(byte[] aFlushingStatement) {
            return "Flushing wasn't successful (\"" + new String(aFlushingStatement) + "\")!";
        }
    }

    private static class CloseException
    extends Exception {
        private CloseException(Throwable aThrowable) {
            super("Error on closing output stream!", aThrowable);
        }
    }
}

