/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry;

import de.novanic.eventservice.client.event.DomainEvent;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.client.event.filter.EventFilter;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEvent;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEventListener;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.event.listener.unlisten.UnlistenEventFilter;
import de.novanic.eventservice.logger.ServerLogger;
import de.novanic.eventservice.logger.ServerLoggerFactory;
import de.novanic.eventservice.service.EventServiceException;
import de.novanic.eventservice.service.UserTimeoutListener;
import de.novanic.eventservice.service.connection.strategy.connector.ConnectionStrategyServerConnector;
import de.novanic.eventservice.service.registry.EventRegistry;
import de.novanic.eventservice.service.registry.domain.ListenDomainAccessor;
import de.novanic.eventservice.service.registry.user.DomainUserMapping;
import de.novanic.eventservice.service.registry.user.UserActivityScheduler;
import de.novanic.eventservice.service.registry.user.UserInfo;
import de.novanic.eventservice.service.registry.user.UserManager;
import de.novanic.eventservice.service.registry.user.UserManagerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventRegistry
implements EventRegistry,
ListenDomainAccessor {
    private static final ServerLogger LOG = ServerLoggerFactory.getServerLogger(DefaultEventRegistry.class.getName());
    private final EventServiceConfiguration myConfiguration;
    private final DomainUserMapping myDomainUserMapping;
    private final UserManager myUserManager;
    private final UserActivityScheduler myUserActivityScheduler;

    protected DefaultEventRegistry(EventServiceConfiguration aConfiguration) {
        this.myConfiguration = aConfiguration;
        this.myDomainUserMapping = new DomainUserMapping();
        this.myUserManager = UserManagerFactory.getInstance().getUserManager(aConfiguration);
        this.myUserActivityScheduler = this.myUserManager.getUserActivityScheduler();
        this.myUserActivityScheduler.addTimeoutListener(new TimeoutListener());
        this.myUserManager.activateUserActivityScheduler();
        LOG.info("Configuration changed - " + aConfiguration.toString());
    }

    @Override
    public boolean isUserRegistered(String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        return this.isUserRegistered(theUserInfo);
    }

    private boolean isUserRegistered(UserInfo aUserInfo) {
        return aUserInfo != null && this.myUserManager.isUserContained(aUserInfo);
    }

    @Override
    public boolean isUserRegistered(Domain aDomain, String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        return this.isUserRegistered(aDomain, theUserInfo);
    }

    private boolean isUserRegistered(Domain aDomain, UserInfo aUserInfo) {
        return aDomain != null && aUserInfo != null && this.myDomainUserMapping.isUserContained(aDomain, aUserInfo);
    }

    @Override
    public void registerUser(Domain aDomain, String aUserId, EventFilter anEventFilter) {
        UserInfo theUserInfo = this.myUserManager.addUser(aUserId);
        if (aDomain != null) {
            this.myDomainUserMapping.addUser(aDomain, theUserInfo);
            LOG.debug("User \"" + aUserId + "\" registered for domain \"" + aDomain + "\".");
            this.setEventFilter(aDomain, theUserInfo, anEventFilter);
        } else {
            LOG.debug("User \"" + aUserId + "\" registered.");
        }
    }

    @Override
    public void setEventFilter(Domain aDomain, String aUserId, EventFilter anEventFilter) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        this.setEventFilter(aDomain, theUserInfo, anEventFilter);
    }

    private void setEventFilter(Domain aDomain, UserInfo aUserInfo, EventFilter anEventFilter) {
        if (aUserInfo != null) {
            if (anEventFilter != null) {
                LOG.debug(aUserInfo.getUserId() + ": EventFilter changed for domain \"" + aDomain + "\".");
                aUserInfo.setEventFilter(aDomain, anEventFilter);
            } else if (aUserInfo.removeEventFilter(aDomain)) {
                LOG.debug(aUserInfo.getUserId() + ": EventFilter removed from domain \"" + aDomain + "\".");
            }
        }
    }

    @Override
    public EventFilter getEventFilter(Domain aDomain, String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        if (theUserInfo != null) {
            return theUserInfo.getEventFilter(aDomain);
        }
        return null;
    }

    @Override
    public void removeEventFilter(Domain aDomain, String aUserId) {
        this.setEventFilter(aDomain, aUserId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DomainEvent> listen(ConnectionStrategyServerConnector aServerEventListener, String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        LOG.debug(aUserId + ": listen (UserInfo " + theUserInfo + ").");
        if (theUserInfo != null) {
            this.myUserActivityScheduler.reportUserActivity(theUserInfo);
            try {
                List<DomainEvent> list = aServerEventListener.listen(theUserInfo);
                return list;
            }
            catch (EventServiceException e) {
                LOG.error("Error on listening for user \"" + theUserInfo + "\" with \"" + aServerEventListener.getClass().getName() + "\"!", e);
            }
            finally {
                this.myUserActivityScheduler.reportUserActivity(theUserInfo);
            }
        }
        return null;
    }

    @Override
    public void unlisten(Domain aDomain, String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        if (theUserInfo != null) {
            if (aDomain != null) {
                LOG.debug(aUserId + ": unlisten (domain \"" + aDomain + "\").");
                if (this.isUserRegistered(aDomain, theUserInfo)) {
                    HashSet<Domain> theDomains = new HashSet<Domain>(1);
                    theDomains.add(aDomain);
                    this.addEvent(DomainFactory.UNLISTEN_DOMAIN, (Event)this.produceUnlistenEvent(theUserInfo, theDomains, false));
                }
                this.removeUser(aDomain, theUserInfo);
            } else if (!this.myDomainUserMapping.isUserContained(theUserInfo)) {
                this.unlisten(theUserInfo, false);
            }
        }
    }

    @Override
    public void unlisten(String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        this.unlisten(theUserInfo, false);
    }

    private void unlisten(UserInfo aUserInfo, boolean isTimeout) {
        if (aUserInfo != null) {
            String theUserId = aUserInfo.getUserId();
            LOG.debug(theUserId + ": unlisten.");
            Set<Domain> theDomains = this.myDomainUserMapping.getDomains(aUserInfo);
            this.addEvent(DomainFactory.UNLISTEN_DOMAIN, (Event)this.produceUnlistenEvent(aUserInfo, theDomains, isTimeout));
            this.removeUser(aUserInfo);
        }
    }

    private boolean removeUser(Domain aDomain, UserInfo aUserInfo) {
        boolean isUserRemoved = this.myDomainUserMapping.removeUser(aDomain, aUserInfo);
        if (isUserRemoved) {
            LOG.debug("User \"" + aUserInfo + "\" removed from domain \"" + aDomain + "\".");
        }
        if (!this.myDomainUserMapping.isUserContained(aUserInfo)) {
            this.myUserManager.removeUser(aUserInfo.getUserId());
        } else {
            aUserInfo.removeEventFilter(aDomain);
        }
        return isUserRemoved;
    }

    private void removeUser(UserInfo aUserInfo) {
        this.myDomainUserMapping.removeUser(aUserInfo);
        if (this.myUserManager.removeUser(aUserInfo.getUserId()) != null) {
            LOG.debug("User \"" + aUserInfo + "\" removed.");
        }
    }

    @Override
    public Set<Domain> getListenDomains(String aUserId) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        return this.getListenDomains(theUserInfo);
    }

    private Set<Domain> getListenDomains(UserInfo aUserInfo) {
        return this.myDomainUserMapping.getDomains(aUserInfo);
    }

    @Override
    public Set<Domain> getListenDomains() {
        return this.myDomainUserMapping.getDomains();
    }

    @Override
    public Set<String> getRegisteredUserIds() {
        return this.getUserIds(this.myUserManager.getUsers());
    }

    @Override
    public Set<String> getRegisteredUserIds(Domain aDomain) {
        return this.getUserIds(this.myDomainUserMapping.getUsers(aDomain));
    }

    @Override
    public void addEvent(Domain aDomain, Event anEvent) {
        LOG.debug("Event \"" + anEvent + "\" added to domain \"" + aDomain + "\".");
        Set<UserInfo> theDomainUsers = this.myDomainUserMapping.getUsers(aDomain);
        if (theDomainUsers != null) {
            for (UserInfo theUserInfo : theDomainUsers) {
                this.addEvent(aDomain, theUserInfo, anEvent);
            }
        }
    }

    @Override
    public void addEventUserSpecific(String aUserId, Event anEvent) {
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        this.addEventUserSpecific(theUserInfo, anEvent);
    }

    private void addEventUserSpecific(UserInfo aUserInfo, Event anEvent) {
        if (aUserInfo != null) {
            LOG.debug("User specific event \"" + anEvent + "\" added to client id \"" + aUserInfo + "\".");
            this.addEvent(DomainFactory.USER_SPECIFIC_DOMAIN, aUserInfo, anEvent);
        }
    }

    @Override
    public void registerUnlistenEvent(String aUserId, UnlistenEventListener.Scope anUnlistenScope, UnlistenEvent anUnlistenEvent) {
        this.registerUser(DomainFactory.UNLISTEN_DOMAIN, aUserId, new UnlistenEventFilter(this, aUserId, anUnlistenScope));
        UserInfo theUserInfo = this.getUserInfo(aUserId);
        theUserInfo.setUnlistenEvent(anUnlistenEvent);
    }

    @Override
    public EventServiceConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    private void addEvent(Domain aDomain, UserInfo aUserInfo, Event anEvent) {
        if (this.isEventValid(anEvent, aUserInfo.getEventFilter(aDomain))) {
            aUserInfo.addEvent(aDomain, anEvent);
            LOG.debug(anEvent + " for user \"" + aUserInfo + "\".");
        }
    }

    private boolean isEventValid(Event anEvent, EventFilter anEventFilter) {
        return anEventFilter == null || !anEventFilter.match(anEvent);
    }

    private UserInfo getUserInfo(String aUserId) {
        return this.myUserManager.getUser(aUserId);
    }

    private UnlistenEvent produceUnlistenEvent(UserInfo aUserInfo, Set<Domain> aDomains, boolean isTimeout) {
        UnlistenEvent theUnlistenEvent = aUserInfo.getUnlistenEvent();
        theUnlistenEvent.setUserId(aUserInfo.getUserId());
        theUnlistenEvent.setDomains(aDomains);
        theUnlistenEvent.setTimeout(isTimeout);
        return theUnlistenEvent;
    }

    private Set<String> getUserIds(Collection<UserInfo> aUserInfoSet) {
        if (aUserInfoSet == null) {
            return new HashSet<String>(0);
        }
        HashSet<String> theUserIdSet = new HashSet<String>(aUserInfoSet.size());
        for (UserInfo theUserInfo : aUserInfoSet) {
            theUserIdSet.add(theUserInfo.getUserId());
        }
        return theUserIdSet;
    }

    private class TimeoutListener
    implements UserTimeoutListener {
        private TimeoutListener() {
        }

        public void onTimeout(UserInfo aUserInfo) {
            LOG.debug(aUserInfo.getUserId() + ": timeout.");
            DefaultEventRegistry.this.unlisten(aUserInfo, true);
        }
    }
}

