/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry;

import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.config.EventServiceConfigurationFactory;
import de.novanic.eventservice.service.registry.DefaultEventRegistry;
import de.novanic.eventservice.service.registry.EventRegistry;
import de.novanic.eventservice.service.registry.user.UserManagerFactory;

public class EventRegistryFactory {
    private volatile EventRegistry myEventRegistry;

    private EventRegistryFactory() {
    }

    public static EventRegistryFactory getInstance() {
        return EventRegistryFactoryHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventRegistry getEventRegistry() {
        if (this.myEventRegistry == null) {
            EventRegistryFactory eventRegistryFactory = this;
            synchronized (eventRegistryFactory) {
                if (this.myEventRegistry == null) {
                    EventServiceConfiguration theConfiguration = this.getEventServiceConfiguration();
                    this.myEventRegistry = new DefaultEventRegistry(theConfiguration);
                }
            }
        }
        return this.myEventRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEventRegistry() {
        EventRegistryFactory eventRegistryFactory = this;
        synchronized (eventRegistryFactory) {
            this.myEventRegistry = null;
            UserManagerFactory.getInstance().getUserManager().reset();
        }
    }

    private EventServiceConfiguration getEventServiceConfiguration() {
        EventServiceConfigurationFactory theConfigurationFactory = EventServiceConfigurationFactory.getInstance();
        return theConfigurationFactory.loadEventServiceConfiguration();
    }

    private static class EventRegistryFactoryHolder {
        private static EventRegistryFactory INSTANCE = new EventRegistryFactory();

        private EventRegistryFactoryHolder() {
        }
    }
}

