/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry.user;

import de.novanic.eventservice.service.registry.user.UserActivityScheduler;
import de.novanic.eventservice.service.registry.user.UserInfo;
import de.novanic.eventservice.service.registry.user.UserManager;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultUserManager
implements UserManager {
    private final ConcurrentMap<String, UserInfo> myUserMap = new ConcurrentHashMap<String, UserInfo>();
    private final UserActivityScheduler myUserActivityScheduler;

    public DefaultUserManager(long aTimeoutInterval) {
        this.myUserActivityScheduler = new UserActivityScheduler(this.myUserMap.values(), aTimeoutInterval);
    }

    @Override
    public UserInfo addUser(String aUserId) {
        UserInfo theNewUserInfo;
        UserInfo theUserInfo = null;
        if (aUserId != null && (theUserInfo = this.myUserMap.putIfAbsent(aUserId, theNewUserInfo = new UserInfo(aUserId))) == null) {
            theUserInfo = theNewUserInfo;
        }
        return theUserInfo;
    }

    @Override
    public void addUser(UserInfo aUserInfo) {
        if (aUserInfo != null) {
            this.myUserMap.put(aUserInfo.getUserId(), aUserInfo);
        }
    }

    @Override
    public UserInfo removeUser(String aUserId) {
        if (aUserId != null) {
            UserInfo theUserInfo = (UserInfo)this.myUserMap.remove(aUserId);
            if (theUserInfo != null) {
                theUserInfo.notifyEventListening();
            }
            return theUserInfo;
        }
        return null;
    }

    @Override
    public boolean removeUser(UserInfo aUserInfo) {
        return aUserInfo != null && this.removeUser(aUserInfo.getUserId()) != null;
    }

    @Override
    public void removeUsers() {
        for (UserInfo theUserInfo : this.myUserMap.values()) {
            theUserInfo.notifyEventListening();
        }
        this.myUserMap.clear();
    }

    @Override
    public boolean isUserContained(UserInfo aUserInfo) {
        return this.myUserMap.containsKey(aUserInfo.getUserId());
    }

    @Override
    public UserInfo getUser(String aUserId) {
        if (aUserId != null) {
            return (UserInfo)this.myUserMap.get(aUserId);
        }
        return null;
    }

    @Override
    public int getUserCount() {
        return this.myUserMap.size();
    }

    @Override
    public Collection<UserInfo> getUsers() {
        return this.myUserMap.values();
    }

    @Override
    public void activateUserActivityScheduler() {
        this.activateUserActivityScheduler(false);
    }

    @Override
    public void activateUserActivityScheduler(boolean isAutoClean) {
        this.myUserActivityScheduler.start(isAutoClean);
    }

    @Override
    public void deactivateUserActivityScheduler() {
        this.myUserActivityScheduler.stop();
    }

    @Override
    public UserActivityScheduler getUserActivityScheduler() {
        return this.myUserActivityScheduler;
    }

    @Override
    public void reset() {
        this.deactivateUserActivityScheduler();
        this.removeUsers();
    }
}

