/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry.user;

import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.service.registry.user.UserInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainUserMapping {
    private final ConcurrentMap<Domain, ConcurrentMap<UserInfo, UserInfo>> myDomainUserInfoMap = new ConcurrentHashMap<Domain, ConcurrentMap<UserInfo, UserInfo>>();

    public void addUser(Domain aDomain, UserInfo aUserInfo) {
        ConcurrentHashMap<UserInfo, UserInfo> theNewUsers;
        ConcurrentHashMap<UserInfo, UserInfo> theUsers = (ConcurrentHashMap<UserInfo, UserInfo>)this.myDomainUserInfoMap.get(aDomain);
        if (theUsers == null && (theUsers = (ConcurrentMap)this.myDomainUserInfoMap.putIfAbsent(aDomain, theNewUsers = new ConcurrentHashMap<UserInfo, UserInfo>())) == null) {
            theUsers = theNewUsers;
        }
        theUsers.putIfAbsent(aUserInfo, aUserInfo);
    }

    public void removeUser(UserInfo aUserInfo) {
        for (Map.Entry theDomainUsersEntry : this.myDomainUserInfoMap.entrySet()) {
            Domain theDomain = (Domain)theDomainUsersEntry.getKey();
            ConcurrentMap theDomainUsers = (ConcurrentMap)theDomainUsersEntry.getValue();
            this.removeUser(theDomain, theDomainUsers, aUserInfo);
        }
    }

    public boolean removeUser(Domain aDomain, UserInfo aUserInfo) {
        ConcurrentMap theDomainUsers;
        boolean isUserRemoved = false;
        if (aDomain != null && aUserInfo != null && (theDomainUsers = (ConcurrentMap)this.myDomainUserInfoMap.get(aDomain)) != null) {
            isUserRemoved = this.removeUser(aDomain, theDomainUsers, aUserInfo);
        }
        return isUserRemoved;
    }

    private boolean removeUser(Domain aDomain, ConcurrentMap<UserInfo, UserInfo> aDomainUsers, UserInfo aUser) {
        boolean isUserRemoved;
        boolean bl = isUserRemoved = aDomainUsers.remove(aUser) != null;
        if (isUserRemoved && aDomainUsers.isEmpty()) {
            this.myDomainUserInfoMap.remove(aDomain, aDomainUsers);
        }
        return isUserRemoved;
    }

    public Set<Domain> getDomains() {
        return this.myDomainUserInfoMap.keySet();
    }

    public Set<Domain> getDomains(UserInfo aUserInfo) {
        if (aUserInfo != null) {
            HashSet<Domain> theDomains = new HashSet<Domain>(this.myDomainUserInfoMap.size());
            for (Map.Entry theDomainUserEntry : this.myDomainUserInfoMap.entrySet()) {
                ConcurrentMap theDomainUsers = (ConcurrentMap)theDomainUserEntry.getValue();
                if (!theDomainUsers.containsKey(aUserInfo)) continue;
                theDomains.add((Domain)theDomainUserEntry.getKey());
            }
            return theDomains;
        }
        return new HashSet<Domain>(0);
    }

    public Set<UserInfo> getUsers(Domain aDomain) {
        if (aDomain != null) {
            ConcurrentMap theUserInfoCollection = (ConcurrentMap)this.myDomainUserInfoMap.get(aDomain);
            if (theUserInfoCollection != null) {
                return new HashSet<UserInfo>(theUserInfoCollection.keySet());
            }
            return new HashSet<UserInfo>(0);
        }
        return null;
    }

    public boolean isUserContained(UserInfo aUserInfo) {
        for (ConcurrentMap theDomainUsers : this.myDomainUserInfoMap.values()) {
            if (!theDomainUsers.containsKey(aUserInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserContained(Domain aDomain, UserInfo aUserInfo) {
        ConcurrentMap theDomainUsers = (ConcurrentMap)this.myDomainUserInfoMap.get(aDomain);
        return theDomainUsers != null && theDomainUsers.containsKey(aUserInfo);
    }
}

