/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry.user;

import de.novanic.eventservice.service.UserTimeoutListener;
import de.novanic.eventservice.service.registry.user.UserInfo;
import de.novanic.eventservice.util.PlatformUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserActivityScheduler {
    private final Collection<UserInfo> myUserInfoCollection;
    private final Queue<UserTimeoutListener> myTimeoutListeners;
    private final long myTimeoutInterval;
    private Timer myTimer;
    private TimeoutTimerTask myTimeoutTimerTask;
    private boolean myIsAutoClean;
    private boolean isActive;

    protected UserActivityScheduler(Collection<UserInfo> aUserInfoCollection, long aTimeoutInterval) {
        this.myUserInfoCollection = aUserInfoCollection;
        this.myTimeoutInterval = aTimeoutInterval;
        this.myTimeoutListeners = new ConcurrentLinkedQueue<UserTimeoutListener>();
    }

    public void addTimeoutListener(UserTimeoutListener aTimeoutListener) {
        this.myTimeoutListeners.add(aTimeoutListener);
    }

    public void removeTimeoutListener(UserTimeoutListener aTimeoutListener) {
        this.myTimeoutListeners.remove(aTimeoutListener);
    }

    public void removeTimeoutListeners() {
        this.myTimeoutListeners.clear();
    }

    public void start(boolean isAutoClean) {
        if (!this.isActive) {
            this.myIsAutoClean = isAutoClean;
            this.myTimer = new Timer("GWTEventService-UserActivityScheduler", true);
            this.myTimeoutTimerTask = new TimeoutTimerTask();
            this.isActive = true;
            this.schedule(this.myTimer, this.myTimeoutTimerTask, this.myTimeoutInterval);
        }
    }

    public void stop() {
        if (this.isActive) {
            this.isActive = false;
            if (this.myTimer != null) {
                this.myTimer.cancel();
            }
            if (this.myTimeoutTimerTask != null) {
                this.myTimeoutTimerTask.cancel();
            }
            if (this.myTimer != null) {
                this.myTimer.purge();
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public long getTimeoutInterval() {
        return this.myTimeoutInterval;
    }

    public void reportUserActivity(UserInfo aUserInfo) {
        aUserInfo.reportUserActivity();
    }

    private void schedule(Timer aTimer, TimeoutTimerTask aTimeoutTimerTask, long aTimeoutInterval) {
        aTimer.schedule((TimerTask)aTimeoutTimerTask, 0L, aTimeoutInterval);
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        public void run() {
            long theTimeoutCriteriaTime = PlatformUtil.getCurrentTime() - UserActivityScheduler.this.myTimeoutInterval;
            Iterator theUserInfoIterator = UserActivityScheduler.this.myUserInfoCollection.iterator();
            while (theUserInfoIterator.hasNext()) {
                UserInfo theUserInfo = (UserInfo)theUserInfoIterator.next();
                if (!this.isTimeout(theUserInfo, theTimeoutCriteriaTime)) continue;
                for (UserTimeoutListener theTimeoutListener : UserActivityScheduler.this.myTimeoutListeners) {
                    theTimeoutListener.onTimeout(theUserInfo);
                }
                if (!UserActivityScheduler.this.myIsAutoClean) continue;
                theUserInfoIterator.remove();
            }
        }

        private boolean isTimeout(UserInfo aUserInfo, long aTimeoutCriteriaTime) {
            return aUserInfo.getLastActivityTime() <= aTimeoutCriteriaTime;
        }
    }
}

