/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry.user;

import de.novanic.eventservice.client.event.DefaultDomainEvent;
import de.novanic.eventservice.client.event.DomainEvent;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.filter.EventFilter;
import de.novanic.eventservice.client.event.listener.unlisten.DefaultUnlistenEvent;
import de.novanic.eventservice.client.event.listener.unlisten.UnlistenEvent;
import de.novanic.eventservice.util.PlatformUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfo
implements Comparable<UserInfo> {
    private final String myUserId;
    private final Queue<DomainEvent> myEvents;
    private final Map<Domain, EventFilter> myDomainEventFilters;
    private UnlistenEvent myUnlistenEvent;
    private volatile long myLastActivityTime;

    public UserInfo(String aUserId) {
        this.myUserId = aUserId;
        this.myEvents = new ConcurrentLinkedQueue<DomainEvent>();
        this.myDomainEventFilters = new ConcurrentHashMap<Domain, EventFilter>();
        this.myLastActivityTime = PlatformUtil.getCurrentTime();
    }

    public String getUserId() {
        return this.myUserId;
    }

    public void addEvent(Domain aDomain, Event anEvent) {
        DefaultDomainEvent theDomainEvent = new DefaultDomainEvent(anEvent, aDomain);
        this.myEvents.add((DomainEvent)theDomainEvent);
        this.notifyEventListening();
    }

    public synchronized void notifyEventListening() {
        this.notifyAll();
    }

    public List<DomainEvent> retrieveEvents(int aMaxEvents) {
        DomainEvent theEvent;
        ArrayList<DomainEvent> theEventList = new ArrayList<DomainEvent>(this.myEvents.size());
        for (int i = 0; i < aMaxEvents && (theEvent = this.myEvents.poll()) != null; ++i) {
            theEventList.add(theEvent);
        }
        return theEventList;
    }

    public boolean isEventsEmpty() {
        return this.myEvents.isEmpty();
    }

    public void setEventFilter(Domain aDomain, EventFilter anEventFilter) {
        if (anEventFilter != null) {
            this.myDomainEventFilters.put(aDomain, anEventFilter);
        }
    }

    public boolean removeEventFilter(Domain aDomain) {
        return aDomain != null && this.myDomainEventFilters.remove(aDomain) != null;
    }

    public EventFilter getEventFilter(Domain aDomain) {
        if (aDomain != null) {
            return this.myDomainEventFilters.get(aDomain);
        }
        return null;
    }

    public UnlistenEvent getUnlistenEvent() {
        if (this.myUnlistenEvent == null) {
            return new DefaultUnlistenEvent();
        }
        return this.myUnlistenEvent;
    }

    public void setUnlistenEvent(UnlistenEvent anUnlistenEvent) {
        this.myUnlistenEvent = anUnlistenEvent;
    }

    public void setLastActivityTime(long aLastActivityTime) {
        this.myLastActivityTime = aLastActivityTime;
    }

    public long getLastActivityTime() {
        return this.myLastActivityTime;
    }

    public void reportUserActivity() {
        this.setLastActivityTime(PlatformUtil.getCurrentTime());
    }

    @Override
    public int compareTo(UserInfo aUserInfo) {
        return this.myUserId.compareTo(aUserInfo.myUserId);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass()) {
            return false;
        }
        UserInfo theOtherUserInfo = (UserInfo)anObject;
        return this.myUserId.equals(theOtherUserInfo.myUserId);
    }

    public int hashCode() {
        return this.myUserId.hashCode();
    }

    public String toString() {
        return this.getUserId();
    }
}

