/*
 * Decompiled with CFR 0.152.
 */
package de.novanic.eventservice.service.registry.user;

import de.novanic.eventservice.client.config.ConfigurationException;
import de.novanic.eventservice.config.EventServiceConfiguration;
import de.novanic.eventservice.service.registry.user.DefaultUserManager;
import de.novanic.eventservice.service.registry.user.UserManager;

public class UserManagerFactory {
    private volatile UserManager myUserManager;

    private UserManagerFactory() {
    }

    public static UserManagerFactory getInstance() {
        return UserManagerFactoryHolder.INSTANCE;
    }

    public UserManager getUserManager() {
        if (this.myUserManager != null) {
            return this.myUserManager;
        }
        throw new ConfigurationException("The UserManager isn't configured! It is necessary to create an instance of UserManager first. That can be done by calling a factory method of UserManagerFactory with a configuration.");
    }

    public UserManager getUserManager(EventServiceConfiguration aConfiguration) {
        return this.getUserManager(aConfiguration.getTimeoutTime().intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserManager getUserManager(long aTimeoutInterval) {
        if (this.myUserManager == null) {
            UserManagerFactory userManagerFactory = this;
            synchronized (userManagerFactory) {
                if (this.myUserManager == null) {
                    this.myUserManager = new DefaultUserManager(aTimeoutInterval);
                }
            }
        }
        return this.myUserManager;
    }

    private static class UserManagerFactoryHolder {
        private static UserManagerFactory INSTANCE = new UserManagerFactory();

        private UserManagerFactoryHolder() {
        }
    }
}

