/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.analysis;

import com.google.common.base.Preconditions;
import de.obqo.decycle.analysis.FileFinder;
import de.obqo.decycle.analysis.GraphBuildingClassVisitor;
import de.obqo.decycle.graph.Graph;
import de.obqo.decycle.model.EdgeFilter;
import de.obqo.decycle.model.NodeFilter;
import de.obqo.decycle.slicer.Categorizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analyzer {
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);

    public Graph analyze(String classpath, Categorizer categorizer, NodeFilter filter, EdgeFilter ignoredEdgesFilter) {
        Preconditions.checkNotNull((Object)classpath, (Object)"classpath must not be null");
        Preconditions.checkNotNull((Object)categorizer, (Object)"categorizer must not be null");
        Preconditions.checkNotNull((Object)filter, (Object)"filter must not be null");
        Preconditions.checkNotNull((Object)ignoredEdgesFilter, (Object)"ignoredEdgesFilter must not be null");
        Graph graph = new Graph(categorizer, filter, ignoredEdgesFilter);
        String[] libs = classpath.split(System.getProperty("path.separator"));
        Stream.of(libs).flatMap(FileFinder::find).forEach(file -> this.analyze((File)file, graph));
        return graph;
    }

    private void analyze(File file, Graph graph) {
        block14: {
            if (file.getName().endsWith(".class")) {
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                    this.readStream(bis, file.getName(), graph);
                    break block14;
                }
            }
            try (ZipFile zipFile = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry e = entries.nextElement();
                    if (!e.getName().endsWith(".class")) continue;
                    this.readStream(zipFile.getInputStream(e), e.getName(), graph);
                }
            }
        }
    }

    private void readStream(InputStream stream, String name, Graph graph) {
        try {
            ClassReader reader = new ClassReader(stream);
            reader.accept((ClassVisitor)new GraphBuildingClassVisitor(graph), 0);
        }
        catch (Exception e) {
            log.error("Decycle: Something went wrong when analyzing " + name, (Throwable)e);
        }
    }
}

